<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('shift_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('shift_info_id'); 
            $table->date('start_date');
            $table->date('end_date')->nullable();
            $table->enum('day_of_week', ['M', 'T', 'W', 'TH', 'F', 'S', 'Sun']);
            $table->time('start_time');
            $table->time('end_time');
            $table->time('break_start_time')->nullable();
            $table->time('break_end_time')->nullable();
            $table->integer('grace_in_minutes')->default(0);
            $table->integer('grace_out_minutes')->default(0);
            $table->boolean('isDefault')->default(false);            
            $table->timestamps();

            $table->foreign('shift_info_id')->references('id')->on('shift_info')->onDelete('cascade');   
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('shift_details');
    }
};
