<x-default-layout>
    @section('title')
        Dashboard
    @endsection

    @section('breadcrumbs')
        {{ Breadcrumbs::render('transactionReportView') }}
    @endsection

    <!--begin::Row-->
    <div class="row g-5 g-xl-10 mb-5 mb-xl-10">
        <table class="table table-bordered" id="transaction-table">
            <thead>
                <tr>
                    <th>Sl. No.</th>
                    <th>Emp. Code</th>
                    <th>Name</th>
                    <th>School</th>
                    <th>Department</th>
                    <th>Action</th>
                </tr>
            </thead>
        </table>
    </div>

    <script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <script type="text/javascript">
    $(function () {
        
        var table = $('#transaction-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route('user-management.assignManager', $user_id) }}',
            columns: [
                {data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false},
                {data: 'username', name: 'username'},
                {data: 'name', name: 'name'},
                {data: 'school.name', name: 'school.name'},
                {data: 'department.name', name: 'department.name'},
                { data: 'action', name: 'action', orderable: false, searchable: false },
            ],
            pageLength: 10, // Adjust this value for the number of rows per page
        });
        
    });
</script>
</x-default-layout>