<x-default-layout>
    @section('title')
        Create Employee
    @endsection

    @section('breadcrumbs')
        {{ Breadcrumbs::render('createEmployee') }}
    @endsection

    <!--begin::Row-->
    <div class="row g-5 g-xl-10 mb-5 mb-xl-10">
        <form action="{{ route('user-management.storeEmployee') }}" method="POST">
            @csrf
            @include('pages/apps/user-management/users/partials.form', ['departments' => $departments, 'schools' => $schools, 'positions' => $positions])
            
            <button type="submit" class="btn btn-primary">Submit</button>
        </form>
    </div>

    <script>
        $(document).ready(function() {
            $('#school_id').on('change', function() {
                var school_id = $(this).val();

                if (school_id) {
                    $.ajax({
                        url: '/get-default-shift-data/' + school_id,
                        method: 'GET',
                        success: function(response) {
                            var defaultDataHtml = '';

                            if (response.related_data.length > 0) {
                                defaultDataHtml += '<ul>';
                                $.each(response.related_data, function(index, data) {
                                    defaultDataHtml += '<li>' + data.name + ': ' + data.value + '</li>'; // Adjust to your actual data fields
                                });
                                defaultDataHtml += '</ul>';
                            } else {
                                defaultDataHtml = '<p>No default data found for this school.</p>';
                            }

                            $('#default-data').html(defaultDataHtml);
                        },
                        error: function(xhr) {
                            $('#default-data').html('<p>Error fetching data.</p>');
                            console.error(xhr.responseJSON.error);
                        }
                    });
                } else {
                    $('#default-data').html(''); // Clear the div if no school is selected
                }
            });
        });

    </script>


</x-default-layout>