<x-default-layout>
    @section('title')
        Create Employee
    @endsection

    @section('breadcrumbs')
        {{ Breadcrumbs::render('editEmployee', 1) }}
    @endsection

    <!--begin::Row-->
    <div class="row g-5 g-xl-10 mb-5 mb-xl-10">
        <form action="{{ route('user-management.updateEmployee', $user->id) }}" method="POST">
            @csrf
            @method('PUT')
            @include('pages/apps/user-management/users/partials.form', ['departments' => $departments, 'schools' => $schools, 'positions' => $positions])
        
            <button type="submit" class="btn btn-primary">Update</button>

        </form>
    </div>
    
    <script type="text/javascript">
    document.addEventListener('DOMContentLoaded', function() {
        var schoolIdElement = document.getElementById('school_id');
        var shiftIdElement = document.getElementById('shift_id');
        var preselectedShiftId = '{{ $user->shift_id ?? '' }}'; 

        function fetchShiftData(school_ids) {
            if (school_ids && school_ids.length > 0) {
                fetch('/post-default-shift-data', {
                    method: 'POST', // Change to POST to send the array of IDs
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({ "_token": "{{ csrf_token() }}", school_ids: school_ids }) // Send the array of school_ids
                })
                .then(response => response.json())
                .then(data => {
                    let selectElement = document.getElementById('shift_id');
                    selectElement.innerHTML = ''; // Clear existing options
                    let defaultDataHtml = '';

                    if (data.related_data && data.related_data.length > 0) {
                        selectElement.innerHTML = '<option value="" selected>Select Shift</option>';
                        
                        data.related_data.forEach(item => {
                            let option = document.createElement('option');
                            option.value = item.id;
                            option.text = item.shift_name + " (" + item.shift_code + ")";

                            // Preselect the option if it matches the preselectedShiftId
                            if (item.id == preselectedShiftId) {
                                option.selected = true;
                            }

                            selectElement.appendChild(option);
                        });
                    } else {
                        selectElement.innerHTML = '<option value="">No shift data available</option>';
                    }                
                })
                .catch(error => {
                    document.getElementById('showShift').innerHTML = '<p>Error fetching data.</p>';
                    console.error(error.message);
                });
                
            }
        }
        
        schoolIdElement.addEventListener('change', function() {
            var selectedOptions = Array.from(this.selectedOptions);
            var school_ids = selectedOptions.map(option => option.value);

            fetchShiftData(school_ids);
        });
        
        if (schoolIdElement.selectedOptions.length > 0) {
            var selectedSchoolIds = Array.from(schoolIdElement.selectedOptions).map(option => option.value);
            fetchShiftData(selectedSchoolIds);
        }
    });
</script>

</x-default-layout>