<div class="mb-3">
    <label for="email" class="form-label">Email</label>
    <input type="email" class="form-control @error('email') is-invalid @enderror" id="email" name="email" value="{{ old('email', $user->email ?? '') }}">
    @error('email')
        <div class="invalid-feedback">{{ $message }}</div>
    @enderror
</div>

<div class="d-flex mb-3">
    <div class="me-3 flex-grow-1">
        <label for="first_name" class="form-label">First Name</label>
        <input type="text" class="form-control @error('first_name') is-invalid @enderror" id="first_name" name="first_name" value="{{ old('first_name', $user->first_name ?? '') }}">
        @error('first_name')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
    <div class="flex-grow-1">
        <label for="last_name" class="form-label">Last Name</label>
        <input type="text" class="form-control @error('last_name') is-invalid @enderror" id="last_name" name="last_name" value="{{ old('last_name', $user->last_name ?? '') }}">
        @error('last_name')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>    
</div>

<div class="d-flex mb-3">
    <div class="me-3 flex-grow-1">
        <label for="username" class="form-label">Employee Id</label>
        <input type="text" class="form-control @error('username') is-invalid @enderror" id="username" name="username" value="{{ old('username', $user->username ?? '') }}">
        @error('username')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
    <div class="me-3 flex-grow-1">
        <label for="hire_date" class="form-label">Hire Date</label>
        <input type="date" class="form-control @error('hire_date') is-invalid @enderror" id="hire_date" name="hire_date" value="{{ old('hire_date', $user->hire_date ?? '') }}">
        @error('hire_date')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
    <div class="flex-grow-1">
        <label for="gender" class="form-label">Gender</label>
        <select class="form-select @error('gender') is-invalid @enderror" id="gender" name="gender">
            <option value="" selected>Select Gender</option>
            <option value="Male" {{ old('gender', $user->gender ?? '') == 'Male' ? 'selected' : '' }}>Male</option>
            <option value="Female" {{ old('gender', $user->gender ?? '') == 'Female' ? 'selected' : '' }}>Female</option>
            <option value="Other" {{ old('gender', $user->gender ?? '') == 'Other' ? 'selected' : '' }}>Other</option>
        </select>
        @error('gender')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
</div>

<div class="d-flex mb-3">
    <div class="me-3 flex-grow-1">
        <label for="department_id" class="form-label">Department</label>
        <select class="form-select @error('department_id') is-invalid @enderror" id="department_id" name="department_id">
            <option value="" selected>Select Department</option>
            @foreach($departments as $department)
                <option value="{{ $department->id }}" {{ old('department_id', $user->department_id ?? '') == $department->id ? 'selected' : '' }}>
                    {{ $department->name }}
                </option>
            @endforeach
        </select>
        @error('department_id')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
    <div class="flex-grow-1">
        <label for="position_id" class="form-label">Position</label>
        <select class="form-select @error('position_id') is-invalid @enderror" id="position_id" name="position_id">
            <option value="" selected>Select Position</option>
            @foreach($positions as $position)
                <option value="{{ $position->id }}" {{ old('position_id', $user->position_id ?? '') == $position->id ? 'selected' : '' }}>
                    {{ $position->name }}
                </option>
            @endforeach
        </select>
        @error('position_id')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
</div>

<div class="d-flex mb-3">
    <div class="me-3 flex-grow-1">
        <label for="school_id" class="form-label">School</label>
        <select class="form-select @error('school_id') is-invalid @enderror" id="school_id" name="school_ids[]" multiple>
            <option value="" selected>Select School</option>
            @foreach($schools as $school)
                <option value="{{ $school->id }}"
                    {{ (isset($user) && in_array($school->id, old('school_ids', $user->schools->pluck('id')->toArray() ?? []))) ? 'selected' : '' }}>
                    {{ $school->name }}
                </option>
            @endforeach
        </select>
        @error('school_id')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
    <div class="flex-grow-1" id="showShift">
        <label for="shift_id" class="form-label">Shift</label>
        <select class="form-select @error('shift_id') is-invalid @enderror" id="shift_id" name="shift_id">
            <option value="" selected>Select Shift</option>
        </select>
        @error('school_id')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
</div>

<div class="d-flex mb-3">
    <div class="me-3 flex-grow-1">
        <label for="isLineManager" class="form-label">Is Line Manager?</label>
        <input type="checkbox" class="form-check-input" id="isLineManager" name="isLineManager" 
            {{ old('isLineManager', $isLineManager ?? false) ? 'checked' : '' }}>
        @error('isLineManager')
            <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>
</div>