<x-default-layout>
    @section('title')
        Change Password
    @endsection

    @section('breadcrumbs')
        {{ Breadcrumbs::render('changePassword') }}
    @endsection

    <!--begin::Row-->
    <div class="row g-5 g-xl-10 mb-5 mb-xl-10">
    <!--begin::Forgot Password Form-->
    <form class="form w-100" method="post" novalidate="novalidate" id="kt_password_reset_form" action="{{ route('change.password') }}">
        @csrf
    
        <!-- Current Password -->
        <div class="fv-row mb-10">
            <label class="required form-label fs-6 mb-2">Current Password</label>
            <input class="form-control form-control-lg form-control-solid @error('current_password') is-invalid @enderror" 
                type="password" 
                placeholder="" 
                name="current_password" 
                autocomplete="off" 
                required 
                minlength="8"/>
            @error('current_password')
            <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
        
        <!-- New Password -->
        <div class="mb-10 fv-row" data-kt-password-meter="true">
            <div class="mb-1">
                <label class="form-label fw-semibold fs-6 mb-2">New Password</label>
                <div class="position-relative mb-3">
                    <input class="form-control form-control-lg form-control-solid @error('password') is-invalid @enderror" 
                        type="password" 
                        placeholder="" 
                        name="password" 
                        autocomplete="off" 
                        required 
                        minlength="8"/>
                    @error('password')
                    <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="text-muted">Use 8 or more characters.</div>
        </div>
        
        <!-- Confirm New Password -->
        <div class="fv-row mb-10">
            <label class="form-label fw-semibold fs-6 mb-2">Confirm New Password</label>
            <input class="form-control form-control-lg form-control-solid @error('password_confirmation') is-invalid @enderror" 
                type="password" 
                placeholder="" 
                name="password_confirmation" 
                autocomplete="off" 
                required 
                minlength="8"/>
            @error('password_confirmation')
            <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
        
        <!-- Submit Buttons -->
        <div class="text-center pt-15">
            <button type="reset" class="btn btn-light me-3" data-kt-users-modal-action="cancel">Discard</button>
            <button type="submit" class="btn btn-primary" data-kt-users-modal-action="submit">
                <span class="indicator-label">Submit</span>
                <span class="indicator-progress">Please wait...
                    <span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
            </button>
        </div>
    </form>

</x-default-layout>
