<x-default-layout>

    @section('title')
        Positions
    @endsection

    @section('breadcrumbs')
        {{ Breadcrumbs::render('positions.index') }}
    @endsection

    <div class="card">
        <div class="card-header border-0 pt-6">
            <div class="card-title">
                <div class="d-flex align-items-center position-relative my-1">
                    {!! getIcon('magnifier','fs-3 position-absolute ms-5') !!}
                    <input type="text" data-kt-user-table-filter="search" class="form-control form-control-solid w-250px ps-13" placeholder="Search position" id="mySearchInput"/>
                </div>
            </div>
            
            <div class="card-toolbar">
                <div class="d-flex justify-content-end" data-kt-user-table-toolbar="base">
                    <button type="button" class="btn btn-light-primary me-2" data-bs-toggle="modal" data-bs-target="#kt_modal_add_position">
                        {!! getIcon('plus-square','fs-3', '', 'i') !!}
                        Add position
                    </button>
                </div>
                <div class="d-flex justify-content-end">
                    <a class="btn btn-light-primary" href="{{ route('syncPositions') }}">
                        {!! getIcon('plus-square','fs-3', '', 'i') !!}
                        Sync Positions
                    </a>
                </div>
            </div>

        </div>        
        <livewire:employee.position-modal></livewire:employee.position-modal>
        
        <div class="card-body py-4">
            <div class="table-responsive">
                {{ $dataTable->table() }}
            </div>
        </div>
    </div>  

    @push('scripts')
        {{ $dataTable->scripts() }}
        <script>
            document.getElementById('mySearchInput').addEventListener('keyup', function () {
                window.LaravelDataTables['positions-table'].search(this.value).draw();
            });
            document.addEventListener('livewire:init', function () {
                Livewire.on('success', function () {
                    $('#kt_modal_update_position').modal('hide');
                    window.LaravelDataTables['positions-table'].ajax.reload();
                });
            });
        </script>
    @endpush

</x-default-layout>
