<x-default-layout>

    @section('title')
        Schools
    @endsection

    @section('breadcrumbs')
        {{ Breadcrumbs::render('schools.index') }}
    @endsection

    <div class="card">
        <!--begin::Card header-->
        <div class="card-header border-0 pt-6">
            <!--begin::Card title-->
            <div class="card-title">
                <!--begin::Search-->
                <div class="d-flex align-items-center position-relative my-1">
                    {!! getIcon('magnifier','fs-3 position-absolute ms-5') !!}
                    <input type="text" data-kt-user-table-filter="search" class="form-control form-control-solid w-250px ps-13" placeholder="Search school" id="mySearchInput"/>
                </div>
                <!--end::Search-->
            </div>
            <!--begin::Card title-->

            <!--begin::Card toolbar-->
            <div class="card-toolbar">     

                <!--begin::Toolbar-->
                <!-- <div class="d-flex justify-content-end" data-kt-user-table-toolbar="base">
                    <button type="button" class="btn btn-light-primary" data-bs-toggle="modal" data-bs-target="#kt_modal_add_school">
                        {!! getIcon('plus-square','fs-3', '', 'i') !!}
                        Add School
                    </button>
                </div> -->
                <div class="d-flex justify-content-end">
                    <a class="btn btn-light-primary" href="{{ route('syncSchools') }}">
                        {!! getIcon('plus-square','fs-3', '', 'i') !!}
                        Sync School
                    </a>
                </div>
                <!--end::Toolbar-->
                
            </div>
            <!--end::Card toolbar-->

        </div>
        <!--end::Card header-->           
        <livewire:school.school-modal></livewire:school.school-modal>

        <!--begin::Card body-->
        <div class="card-body py-4">
            <!--begin::Table-->
            <div class="table-responsive">
                {{ $dataTable->table() }}
            </div>
            <!--end::Table-->
        </div>
        <!--end::Card body-->
    </div>

   

    @push('scripts')
        {{ $dataTable->scripts() }}
        <script>
            document.getElementById('mySearchInput').addEventListener('keyup', function () {
                window.LaravelDataTables['schools-table'].search(this.value).draw();
            });
            document.addEventListener('livewire:init', function () {
                Livewire.on('success', function () {
                    $('#kt_modal_update_school').modal('hide');
                    window.LaravelDataTables['schools-table'].ajax.reload();
                });
            });
        </script>
    @endpush

</x-default-layout>
