<x-default-layout>

    @section('title')
        Shift Details
    @endsection

    @section('breadcrumbs')
        {{ Breadcrumbs::render('shiftDetails', 5) }}
    @endsection

    <!--begin::Row-->
    <div class="row g-5 g-xl-10 mb-5 mb-xl-10">

        <div class="d-flex justify-content-end" data-kt-user-table-toolbar="base">
            <a href="{{ route('shift_details.create', $shift_info_id) }}" class="btn btn-primary mb-3">Create Shift Details</a>
        </div>

        <table class="table table-bordered">
            <tr>
                <th>Start Date</th>
                <th>End Date</th>
                <th>Day of Week</th>
                <th>Start Time</th>
                <th>End Time</th>
                <th>Break Start Time</th>
                <th>Break End Time</th>
                <th>Grace In Minutes</th>
                <th>Grace Out Minutes</th>
                <th>Is default</th>
                <th>Actions</th>
            </tr>
                @if($shiftDetails)
                    @foreach ($shiftDetails as $shiftDetail)
                        <tr>
                            <td>{{ helperformatDate($shiftDetail->start_date) }}</td>
                            <td>{{ helperformatDate($shiftDetail->end_date) }}</td>
                            <td>{{ $shiftDetail->day_of_week }}</td>
                            <td>{{ helperformatTime($shiftDetail->start_time) }}</td>
                            <td>{{ helperformatTime($shiftDetail->end_time) }}</td> 
                            <td>{{ helperformatTime($shiftDetail->break_start_time) }}</td>
                            <td>{{ helperformatTime($shiftDetail->break_end_time) }}</td>
                            <td>{{ $shiftDetail->grace_in_minutes }}</td>
                            <td>{{ $shiftDetail->grace_out_minutes }}</td>
                            <td>{{ $shiftDetail->isDefault ? 'Y' :'N' }}</td>
                            <td>
                                <a href="{{ route('shift_details.edit', $shiftDetail->id) }}" class="btn btn-warning">Edit</a>
                                <form action="{{ route('shift_details.destroy', $shiftDetail->id) }}" method="POST" style="display:inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                @else
                    <tr>
                        <td colspan="7" style="text-align: center;" >No data available in table</td>
                    </tr>
                @endif
        </table>
    </div>
</x-default-layout>