<div class="d-flex mb-3">
    <div class="me-3 flex-grow-1">
        <label for="start_date" class="form-label">Start Date</label>
        <input type="date" class="form-control" id="start_date" name="start_date" value="{{ old('start_date', $shiftDetail->start_date ?? '') }}">
        @error('start_date')
            <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>
    <div class="flex-grow-1">
        <label for="end_date" class="form-label">End Date</label>
        <input type="date" class="form-control" id="end_date" name="end_date" value="{{ old('end_date', $shiftDetail->end_date ?? '') }}">
        @error('end_date')
            <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>
</div>

<div class="mb-3">
    <label for="day_of_week" class="form-label">Day of Week</label>
    <select class="form-control" id="day_of_week" name="day_of_week">
        <option value="MF" {{ old('day_of_week', $shiftDetail->day_of_week ?? '') == 'MF' ? 'selected' : '' }}>Monday-Friday</option>
        <option value="MS" {{ old('day_of_week', $shiftDetail->day_of_week ?? '') == 'MS' ? 'selected' : '' }}>Monday-Saturday</option>
        <option value="M" {{ old('day_of_week', $shiftDetail->day_of_week ?? '') == 'M' ? 'selected' : '' }}>Monday</option>
        <option value="T" {{ old('day_of_week', $shiftDetail->day_of_week ?? '') == 'T' ? 'selected' : '' }}>Tuesday</option>
        <option value="W" {{ old('day_of_week', $shiftDetail->day_of_week ?? '') == 'W' ? 'selected' : '' }}>Wednesday</option>
        <option value="TH" {{ old('day_of_week', $shiftDetail->day_of_week ?? '') == 'TH' ? 'selected' : '' }}>Thursday</option>
        <option value="F" {{ old('day_of_week', $shiftDetail->day_of_week ?? '') == 'F' ? 'selected' : '' }}>Friday</option>
        <option value="S" {{ old('day_of_week', $shiftDetail->day_of_week ?? '') == 'S' ? 'selected' : '' }}>Saturday</option>
        <option value="Sun" {{ old('day_of_week', $shiftDetail->day_of_week ?? '') == 'Sun' ? 'selected' : '' }}>Sunday</option>
    </select>
    @error('day_of_week')
        <div class="text-danger">{{ $message }}</div>
    @enderror
</div>

<div class="d-flex mb-3">
    <div class="me-3 flex-grow-1">
        <label for="start_time" class="form-label">Start Time</label>
        <input type="time" class="form-control" id="start_time" name="start_time" value="{{ old('start_time', $shiftDetail->start_time ?? '') }}">
        @error('start_time')
            <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>
    <div class="flex-grow-1">
        <label for="end_time" class="form-label">End Time</label>
        <input type="time" class="form-control" id="end_time" name="end_time" value="{{ old('end_time', $shiftDetail->end_time ?? '') }}">
        @error('end_time')
            <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>
</div>

<div class="d-flex mb-3">
    <div class="me-3 flex-grow-1">
        <label for="break_start_time" class="form-label">Break Start Time</label>
        <button type="button" class="btn btn-primary btn-sm" onclick="clearTime('break_start_time')" style="padding: 2px 5px;">Clear Time</button>
        <input type="time" class="form-control" id="break_start_time" name="break_start_time" value="{{ old('break_start_time', $shiftDetail->break_start_time ?? '') }}">
        @error('break_start_time')
            <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>
    <div class="flex-grow-1">
        <label for="break_end_time" class="form-label">Break End Time</label>
        <button type="button" class="btn btn-primary btn-sm" onclick="clearTime('break_end_time')" style="padding: 2px 5px;">Clear Time</button>
        <input type="time" class="form-control" id="break_end_time" name="break_end_time" value="{{ old('break_end_time', $shiftDetail->break_end_time ?? '') }}">
        @error('break_end_time')
            <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>
</div>

<div class="d-flex mb-3">
    <div class="me-3 flex-grow-1">
        <label for="grace_in_minutes" class="form-label">Grace In Minutes</label>
        <input type="number" class="form-control" id="grace_in_minutes" name="grace_in_minutes" value="{{ old('grace_in_minutes', $shiftDetail->grace_in_minutes ?? '') }}" min="0">
        @error('grace_in_minutes')
            <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>
    <div class="flex-grow-1">
        <label for="grace_out_minutes" class="form-label">Grace Out Minutes</label>
        <input type="number" class="form-control" id="grace_out_minutes" name="grace_out_minutes" value="{{ old('grace_out_minutes', $shiftDetail->grace_out_minutes ?? '') }}" min="0">
        @error('grace_out_minutes')
            <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>
</div>

<div class="d-flex mb-3">
    <div class="me-3 flex-grow-1">
        <label for="isDefault" class="form-label">Is Default?</label>
        <input type="checkbox" class="form-check-input" id="isDefault" name="isDefault" 
            {{ old('isDefault', $shiftDetail->isDefault ?? false) ? 'checked' : '' }}>
        @error('isDefault')
            <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>
</div>

