<x-default-layout>

    @section('title')
        Shift Master
    @endsection

    @section('breadcrumbs')
        {{ Breadcrumbs::render('shiftManager') }}
    @endsection

    <!--begin::Row-->
    <div class="row g-5 g-xl-10 mb-5 mb-xl-10">

        <div class="d-flex justify-content-end" data-kt-user-table-toolbar="base">
            <a href="{{ route('shift_manager.create') }}" class="btn btn-primary mb-3">Create Shift</a>
        </div>

        <table class="table table-bordered">
            <tr>
                <th>School</th>
                <th>Shift Code</th>
                <th>Start Name</th>
            </tr>
            @foreach ($shifts as $shiftMaster)
            <tr>
                <td>{{ $shiftMaster->school->name }}</td>
                <td>{{ $shiftMaster->shift_code }}</td>
                <td>{{ $shiftMaster->shift_name }}</td>
                <td>
                    <a href="{{ route('shift_details.index', $shiftMaster->id) }}" class="btn btn-info">View Shift Details</a>
                    <a href="{{ route('shift_manager.edit', $shiftMaster->id) }}" class="btn btn-warning">Edit</a>
                </td>
            </tr>
            @endforeach
        </table>
    </div>
</x-default-layout>