<input type="hidden" class="form-control" id="user_id" name="user_id" value="{{ \Auth::id() }}">

<div class="d-flex mb-3">
    <div class="me-3 flex-grow-1">
        <label for="school_id" class="form-label">School</label>
        <select class="form-select @error('school_id') is-invalid @enderror" id="school_id" name="school_id">
            <option value="" selected>Select School</option>
            @foreach($schools as $school)
                <option value="{{ $school->id }}" {{ old('school_id', $shiftInfo->school_id ?? '') == $school->id ? 'selected' : '' }}>
                    {{ $school->name }}
                </option>
            @endforeach
        </select>
        @error('school_id')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
    <div class="flex-grow-1">
        <label for="shift_code" class="form-label">Shift Code</label>
        <input type="text" class="form-control" id="shift_code" name="shift_code" value="{{ old('shift_code', $shiftInfo->shift_code ?? '') }}">
        @error('shift_code')
            <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>
</div>
<div class="d-flex mb-3">
    <div class="flex-grow-1">
        <label for="shift_name" class="form-label">Shift Name</label>
        <input type="text" class="form-control" id="shift_name" name="shift_name" value="{{ old('shift_name', $shiftInfo->shift_name ?? '') }}">
        @error('shift_name')
            <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>
    <div class="flex-grow-1"></div>
</div>