<x-default-layout>

    @section('title')
        Team Member Attendance
    @endsection

    @section('breadcrumbs')
        {{ Breadcrumbs::render('teamMemberAttendance', $user) }}
    @endsection

    <!--begin::Row-->
    <div class="row g-5 g-xl-10 mb-5 mb-xl-10">

        <div class="d-flex justify-content-end mb-3">
            <div class="btn-group" role="group">
                <a href="{{ route('teamMemberAttendance', ['userId' => $user->id, 'monthType' => 'previous']) }}" class="btn btn-secondary {{ $monthType === 'previous' ? 'active' : '' }}">
                    Previous Month
                </a>
                <a href="{{ route('teamMemberAttendance', ['userId' => $user->id, 'monthType' => 'current']) }}" class="btn btn-secondary {{ $monthType === 'current' ? 'active' : '' }}">
                    Current Month
                </a>
            </div>
        </div>

        <div class="col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-md-5 mb-xl-10">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Punch-In Time</th>
                    <th>Punch-Out Time</th>
                    <th>Total Hours Worked</th>
                    <th>Status</th>
                    <th>Comments</th>
                    <th>System</th>
                    <th>Permission In</th>	
                    <th>Permission Out</th>	
                    <th>Total Break Hours</th>	
                    <th>Shift Code</th>
                </tr>
            </thead>
            <tbody>
                @if($attendance)
                    @foreach($attendance as $date => $record)
                        @php 
                            $displayRegularize = $record['status'] !== "Present" && $record['status'] !== "Rest Day" && $record['status'] !== "Pending" && $record['status'] !== "Approved" && $record['is_approved_leave'] !== 1;
                        @endphp
                        <tr class="{{ $record['status'] == 'Rest Day' ? 'table-success' : ($displayRegularize ? 'table-danger' : '') }}">
                            <td>{{ helperformatDate($date) }}</td>
                            <td>
                                @if(isset($record['change_login_in']) && $record['login_time'])
                                    <span data-bs-toggle="tooltip" data-bs-placement="top" title="{{ helperformatTime($record['change_login_in']) }}" style="border-bottom: 2px darkblue dotted;">
                                        {{ helperformatTime($record['login_time']) }}
                                    </span>
                                @else
                                    <span>{{ helperformatTime($record['login_time']) ?? 'N/A' }}</span>
                                @endif               
                            </td>

                            <td>
                                @if(isset($record['change_login_out']) && $record['logout_time'])
                                    <span data-bs-toggle="tooltip" data-bs-placement="top" title="{{ helperformatTime($record['change_login_out']) }}" style="border-bottom: 2px darkblue dotted;">
                                        {{ helperformatTime($record['logout_time']) }}
                                    </span>
                                @else
                                    <span>{{ helperformatTime($record['logout_time']) ?? 'N/A' }}</span>
                                @endif               
                            </td>
                            
                            <td>{{ $record['hours_worked'] ?? 'N/A' }}</td>
                            <td>{{ $record['status'] ?? 'N/A' }}</td>                  
                            <td></td>
                            <td>{{ ($record['is_corrected']) ? 'Mod' : 'Sys' }}</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                    @endforeach
                @else
                    <tr>
                        <td colspan="12" style="text-align: center;" >No data available in table</td>
                    </tr>
                @endif
            </tbody>
        </table>

        </div>
    </div>
</x-default-layout>
