<x-default-layout>

    @section('title')
        Users
    @endsection

    @section('breadcrumbs')
        {{ Breadcrumbs::render('teamMembers') }}
    @endsection

    <div class="d-flex flex-column">
    <!--begin::User Cards Row-->
    <div class="row">
        @foreach($members as $user)
        <!--begin::Card-->
        <div class="col-12 col-md-6 col-lg-3 mb-5">
            <div class="card h-100">
                <!--begin::Card body-->
                <div class="card-body">
                    <div class="d-flex flex-center flex-column py-5">
                        <a href="{{ route('teamMemberAttendance', ['userId' => $user->id, 'monthType' => 'current']) }}" class="fs-3 text-gray-800 text-hover-primary fw-bold mb-3">{{ $user->name }}</a>
                        <div class="badge badge-lg badge-light-primary d-inline">{{ ucwords($user->department->name) }}</div>
                    </div>
                    <div class="separator"></div>
                    <!--begin::Details content-->
                    <div id="kt_user_view_details" class="collapse show">
                        <div class="pb-5 fs-6">
                            <div class="fw-bold mt-5">Emp ID</div>
                            <div class="text-gray-600">{{ $user->username }}</div>
                            <div class="fw-bold mt-5">Email</div>
                            <div class="text-gray-600">
                                <a href="#" class="text-gray-600 text-hover-primary">{{ $user->email }}</a>
                            </div>
                            <div class="fw-bold mt-5">School</div>
                            
                            @foreach($user->schools as $school)
                                <div class="text-gray-600">
                                    <a href="#" class="text-gray-600 text-hover-primary">{{ ucwords($school->name) }}</a>
                                </div>
                            @endforeach
                                
                        </div>
                    </div>
                    <!--end::Details content-->
                </div>
                <!--end::Card body-->
            </div>
        </div>
        <!--end::Card-->
        @endforeach
    </div>
    <!--end::User Cards Row-->
</div>

</x-default-layout>