<x-default-layout>

    @section('title')
        My Attendance
    @endsection

    @section('breadcrumbs')
        {{ Breadcrumbs::render('transactionMyAttendance') }}
    @endsection

    <!--begin::Row-->
    <div class="row g-5 g-xl-10 mb-5 mb-xl-10">

        <div class="d-flex justify-content-end mb-3">
            <div class="btn-group" role="group">
                <a href="{{ route('transactionMyAttendance', ['monthType' => 'previous']) }}" class="btn btn-secondary {{ $monthType === 'previous' ? 'active' : '' }}">
                    Previous Month
                </a>
                <a href="{{ route('transactionMyAttendance', ['monthType' => 'current']) }}" class="btn btn-secondary {{ $monthType === 'current' ? 'active' : '' }}">
                    Current Month
                </a>
            </div>
        </div>

        <div class="col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-md-5 mb-xl-10">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Punch-In Time</th>
                    <th>Punch-Out Time</th>
                    <th>Total Hours Worked</th>
                    <th>Action</th>
                    <th>Status</th>
                    <th>Comments</th>
                    <th>System</th>
                    <th>Permission In</th>	
                    <th>Permission Out</th>	
                    <th>Total Break Hours</th>	
                    <th>Shift Code</th>
                </tr>
            </thead>
            <tbody>
                @if($attendance)
                    @foreach($attendance as $date => $record)
                        @php 
                            $displayRegularize = $record['status'] !== "Present" && $record['status'] !== "Rest Day" && $record['status'] !== "Pending" && $record['status'] !== "Approved" && $record['is_approved_leave'] !== 1;
                        @endphp
                        <tr class="{{ $record['status'] == 'Rest Day' ? 'table-success' : ($displayRegularize ? 'table-danger' : '') }}">

                            <td>{{ helperformatDate($date, "d-m-Y (l)") }}</td>
                            <td>
                                @if(isset($record['change_login_in']) && $record['login_time'])
                                    <span data-bs-toggle="tooltip" data-bs-placement="top" title="{{ helperformatTime($record['change_login_in']) }}" style="border-bottom: 2px darkblue dotted;">
                                        {{ helperformatTime($record['login_time']) }}
                                    </span>
                                @else
                                    <span>{{ helperformatTime($record['login_time']) ?? 'N/A' }}</span>
                                @endif               
                            </td>

                            <td>
                                @if(isset($record['change_login_out']) && $record['logout_time'])
                                    <span data-bs-toggle="tooltip" data-bs-placement="top" title="{{ helperformatTime($record['change_login_out']) }}" style="border-bottom: 2px darkblue dotted;">
                                        {{ helperformatTime($record['logout_time']) }}
                                    </span>
                                @else
                                    <span>{{ helperformatTime($record['logout_time']) ?? 'N/A' }}</span>
                                @endif               
                            </td>
                            
                            <td>{{ $record['hours_worked'] ?? 'N/A' }}</td> 
                            <td>
                                @if($displayRegularize)
                                    <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#attendanceModal" data-date="{{ $date }}" data-punch_in="{{ $record['login_time'] }}"
                                    data-punch_out="{{ $record['logout_time'] }}">
                                    Regularize
                                    </button>
                                @endif
                            </td>       
                            <td>{{ $record['status'] ?? 'N/A' }}</td>                  
                            <td>{{ $record['rejection_reason'] }}</td>
                            <td>{{ ($record['is_corrected']) ? 'Mod' : 'Sys' }}</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                    @endforeach
                @else
                    <tr>
                        <td colspan="12" style="text-align: center;" >No data available in table</td>
                    </tr>
                @endif
            </tbody>
        </table>

        </div>
    </div>

    <div class="modal fade" id="attendanceModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Regularize Your Attendance</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="submitForm" method="POST" action="{{ route('myAttendance.submit') }}">
                    <div class="modal-body">
                        @csrf
                        <div class="mb-3">
                            <label for="date" class="form-label">Date</label>
                            <input type="text" class="form-control" id="date" name="attendance_date" readonly style="background-color: #e9ecef; color: #6c757d;">
                        </div>

                        <!-- Radio Buttons -->
                        <div class="mb-3">
                            <label class="form-label">Modify Options</label><br>
                            <input type="radio" id="modify_in_time" name="regularization_type" value="in_time"> Modify In Time<br>
                            <input type="radio" id="modify_out_time" name="regularization_type" value="out_time"> Modify Out Time<br>
                            <input type="radio" id="modify_in_out_time" name="regularization_type" value="in_out_time"> Modify In/Out Time<br>
                            <input type="radio" id="request_approved_leave" name="regularization_type" value="approved_leave"> Request to mark as approved leave
                        </div>

                        <!-- Modify In Time Field -->
                        <div class="mb-3" id="modify_in_time_field">
                            <label for="punch_in" class="form-label">Modify In Time</label>
                            <input type="time" class="form-control" id="punch_in" name="punch_in"  step="1">
                        </div>

                        <!-- Modify Out Time Field -->
                        <div class="mb-3" id="modify_out_time_field">
                            <label for="punch_out" class="form-label">Modify Out Time</label>
                            <input type="time" class="form-control" id="punch_out" name="punch_out"  step="1">
                        </div>

                        <div class="mb-3">
                            <label for="reason" class="form-label">Reason</label>
                            <textarea class="form-control" id="reason" name="reason" required></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-sm btn-primary">Save changes</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <script type="text/javascript">

        document.addEventListener('DOMContentLoaded', function() {
            // Hide fields on load
            document.getElementById('modify_in_time_field').style.display = 'none';
            document.getElementById('modify_out_time_field').style.display = 'none';

            // Add event listeners to radio buttons
            document.getElementById('modify_in_time').addEventListener('change', function() {
                document.getElementById('modify_in_time_field').style.display = 'block';
                document.getElementById('modify_out_time_field').style.display = 'none';
                document.getElementById('reason').setAttribute('required', 'required');
            });

            document.getElementById('modify_out_time').addEventListener('change', function() {
                document.getElementById('modify_in_time_field').style.display = 'none';
                document.getElementById('modify_out_time_field').style.display = 'block';
                document.getElementById('reason').setAttribute('required', 'required');
            });

            document.getElementById('modify_in_out_time').addEventListener('change', function() {
                document.getElementById('modify_in_time_field').style.display = 'block';
                document.getElementById('modify_out_time_field').style.display = 'block';
                document.getElementById('reason').setAttribute('required', 'required');
            });

            document.getElementById('request_approved_leave').addEventListener('change', function() {
                document.getElementById('modify_in_time_field').style.display = 'none';
                document.getElementById('modify_out_time_field').style.display = 'none';
                document.getElementById('reason').removeAttribute('required');
            });
        });

		var attendanceModal = document.getElementById('attendanceModal');
        
        attendanceModal.addEventListener('show.bs.modal', function (event) {
            var button = event.relatedTarget
            var date = button.getAttribute('data-date');
            var punch_in = button.getAttribute('data-punch_in');
            var punch_out = button.getAttribute('data-punch_out');

            // Update the modal's content.
            var modalDate = attendanceModal.querySelector('#date');
            var modalPunchIn = attendanceModal.querySelector('#punch_in');
            var modalPunchOut = attendanceModal.querySelector('#punch_out');

            modalDate.value = date;
            modalPunchIn.value = punch_in;
            modalPunchOut.value = punch_out;
        })

	</script>

    <!--end::Row-->
</x-default-layout>
