<x-default-layout>

    @section('title')
        Regularizing Team Attendance
    @endsection

    @section('breadcrumbs')
        {{ Breadcrumbs::render('regularizeAttendance') }}
    @endsection

    <!--begin::Row-->
    <div class="row g-5 g-xl-10 mb-5 mb-xl-10">
        <div class="col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-md-5 mb-xl-10">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Emp. Code</th>
                    <th>Name</th>
                    <th>Date</th>
                    <th>Punch-In Time</th>
                    <th>Punch-Out Time</th>
                    <th>Reason</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @if(!$usersWithTransactions->isEmpty())
                    @foreach($usersWithTransactions as $user)
                        @foreach($user->transactionRegularizations as $transaction)
                            <tr>
                                <td>{{ $user->username }}</td>
                                <td>{{ $user->name }}</td>
                                <td>{{ helperformatDate($transaction->attendance_date) }}</td>
                                <td>{{ helperformatTime($transaction->punch_in) }}</td>
                                <td>{{ helperformatTime($transaction->punch_out) }}</td>
                                <td>{{ $transaction->reason }}</td>
                                <td>{{ $transaction->status }}</td>
                                <td>
                                    <form action="{{ route('submitApproveAttendance.submit') }}" method="POST" style="display:inline;">
                                        @csrf
                                        <input type="hidden" name="status" value="Approved"/>
                                        <input type="hidden" name="transactionRegularizationId" value="{{ $transaction->id }}"/>
                                        <button type="submit" class="btn btn-sm btn-success">Approve</button>
                                    </form>
                                    <button type="button" class="btn btn-sm btn-danger" onclick="openRejectModal({{ $transaction->id }})">Reject</button>
                                </td>
                            </tr>
                        @endforeach
                    @endforeach
                @else
                    <tr>
                        <td colspan="7" style="text-align: center;" >No data available in table</td>
                    </tr>
                @endif
            </tbody>
        </table>

        </div>
    </div>

    <div class="modal fade" id="rejectModal" tabindex="-1" aria-labelledby="rejectModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="rejectModalLabel">Reason for Rejection</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="rejectForm" action="{{ route('submitApproveAttendance.submit') }}" method="POST">
                    @csrf
                    <input type="hidden" name="status" value="Rejected"/>
                    <input type="hidden" id="transactionRegularizationId" name="transactionRegularizationId" value=""/>
                    <div class="form-group">
                        <label for="rejection_reason">Rejection Reason</label>
                        <textarea class="form-control" id="rejection_reason" name="rejection_reason" rows="3" required></textarea>
                    </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-danger" form="rejectForm">Submit Rejection</button>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        function openRejectModal(transactionId) {
            // Set the hidden input value in the modal form
            document.getElementById('transactionRegularizationId').value = transactionId;
            // Show the modal
            $('#rejectModal').modal('show');
        }
    </script>

</x-default-layout>
