<x-default-layout>
    @section('title')
        Dashboard
    @endsection

    @section('breadcrumbs')
        {{ Breadcrumbs::render('transactionReportView') }}
    @endsection

    <!--begin::Row-->
    <div class="row g-5 g-xl-10 mb-5 mb-xl-10">
        <table class="table table-bordered" id="transaction-table">
            <thead>
                <tr>
                    <th>Sl. No.</th>
                    <th>Date</th>
                    <th>Punch-In Time</th>
                    <th>Punch-Out Time</th>
                    <th>System</th>
                </tr>
            </thead>
        </table>
    </div>

    <script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <script type="text/javascript">
    $(function () {
        
        var table = $('#transaction-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('transactionReportView') }}",
            columns: [
                {data: 'DT_RowIndex', name: 'DT_RowIndex'},
                {data: 'date', name: 'date'},
                {data: 'login_time', name: 'login_time'},
                {data: 'logout_time', name: 'logout_time'},
                { 
                    "data": "is_corrected", 
                    "name": "is_corrected",
                    "render": function(data, type, row) {
                        return data ? "Mod" : "Sys";
                    }
                }
            ],
            pageLength: 10, // Adjust this value for the number of rows per page
        });
        
    });
</script>
</x-default-layout>