<x-default-layout>
    @section('title')
        Dashboard
    @endsection

    @section('breadcrumbs')
        {{ Breadcrumbs::render('transactionRequestView') }}
    @endsection

    <!--begin::Row-->
    <div class="row g-5 g-xl-10 mb-5 mb-xl-10">
        <div class="col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-md-5 mb-xl-10">
        <table class="table table-striped table-bordered">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Login Time</th>
                    <th>Logout Time</th>
                    <th>Approved By</th>
                    <th>Regularize Type</th>
                    <th>Reason</th>
                </tr>
            </thead>
            <tbody>
                @foreach($pendingRegularization as $date => $data)
                    <tr>
                        <td>{{ date('d-m-Y', strtotime($data['attendance_date'])) }}</td>
                        <td>{{ $data['punch_in'] ?? 'N/A' }}</td>
                        <td>{{ $data['punch_out'] ?? 'N/A' }}</td>
                        <td>{{ $data->approver['name'] ?? 'N/A' }}</td>
                        <td>{{ ucwords(str_replace('_', ' ', $data['regularization_type'] ?? 'N/A')) }}</td>
                        <td>{{ $data['reason'] ?? 'N/A' }}</td>                        
                    </tr>
                @endforeach
            </tbody>
        </table>

        </div>
    </div>
    <!--end::Row-->
</x-default-layout>
