<?php

use App\Models\User;
use Diglactic\Breadcrumbs\Breadcrumbs;
use Diglactic\Breadcrumbs\Generator as BreadcrumbTrail;
use Spatie\Permission\Models\Role;

// Home
Breadcrumbs::for('home', function (BreadcrumbTrail $trail) {
    $trail->push('Home', route('dashboard'));
});

// Home > Dashboard
Breadcrumbs::for('dashboard', function (BreadcrumbTrail $trail) {
    $trail->parent('home');
    $trail->push('Dashboard', route('dashboard'));
});

// Home > Schools
Breadcrumbs::for('schools.index', function (BreadcrumbTrail $trail) {
    $trail->parent('home');
    $trail->push('Dashboard', route('schools.index'));
});

Breadcrumbs::for('departments.index', function (BreadcrumbTrail $trail) {
    $trail->parent('home');
    $trail->push('Departments', route('departments.index'));
});

Breadcrumbs::for('positions.index', function (BreadcrumbTrail $trail) {
    $trail->parent('home');
    $trail->push('Positions', route('positions.index'));
});

Breadcrumbs::for('transactionMyAttendance', function (BreadcrumbTrail $trail) {
    $trail->parent('home');
    $trail->push('My Attendance', route('transactionMyAttendance'));
});

Breadcrumbs::for('regularizeAttendance', function (BreadcrumbTrail $trail) {
    $trail->parent('home');
    $trail->push('Regularize Attendance', route('regularizeAttendance'));
});

Breadcrumbs::for('transactionRequestView', function (BreadcrumbTrail $trail) {
    $trail->parent('home');
    $trail->push('Request View', route('transactionRequestView'));
});

Breadcrumbs::for('transactionReportView', function (BreadcrumbTrail $trail) {
    $trail->parent('home');
    $trail->push('Report View', route('transactionReportView'));
});


Breadcrumbs::for('teamDayAttendance', function (BreadcrumbTrail $trail) {
    $trail->parent('home');
    $trail->push('Day Attendance', route('teamDayAttendance'));
});

Breadcrumbs::for('teamMembers', function (BreadcrumbTrail $trail) {
    $trail->parent('home');
    $trail->push('Team Members', route('teamMembers'));
});

Breadcrumbs::for('teammemberReport', function (BreadcrumbTrail $trail) {
    $trail->parent('home');
    $trail->push('Team Members Report', route('teammemberReport'));
});

Breadcrumbs::for('changePassword', function (BreadcrumbTrail $trail) {
    $trail->parent('home');
    $trail->push('Change Password', route('getChangePassword'));
});

Breadcrumbs::for('shiftManager', function (BreadcrumbTrail $trail) {
    $trail->parent('home');
    $trail->push('Shift Manager', route('shift_manager.index'));
});

Breadcrumbs::for('shiftDetails', function (BreadcrumbTrail $trail,int $shift_info_id ) {
    $trail->parent('shiftManager');
    $trail->push('Shift Details', route('shift_details.index', $shift_info_id));
});

Breadcrumbs::for('teamMemberAttendance', function (BreadcrumbTrail $trail, User $user) {
    $trail->parent('teamMembers');
    $trail->push(ucwords($user->name), route('teamMemberAttendance', $user));
});


// Home > Dashboard > User Management
Breadcrumbs::for('user-management.index', function (BreadcrumbTrail $trail) {
    $trail->parent('dashboard');
    $trail->push('User Management', route('user-management.users.index'));
});

Breadcrumbs::for('createEmployee', function (BreadcrumbTrail $trail) {
    $trail->parent('user-management.index');
    $trail->push('Create Employee', route('user-management.createEmployee'));
});

Breadcrumbs::for('editEmployee', function (BreadcrumbTrail $trail, int $user_id) {
    $trail->parent('user-management.index');
    $trail->push('Edit Employee', route('user-management.editEmployee', $user_id));
});



// Home > Dashboard > User Management > Users
Breadcrumbs::for('user-management.users.index', function (BreadcrumbTrail $trail) {
    $trail->parent('user-management.index');
    $trail->push('Users', route('user-management.users.index'));
});

// Home > Dashboard > User Management > Users > [User]
Breadcrumbs::for('user-management.users.show', function (BreadcrumbTrail $trail, User $user) {
    $trail->parent('user-management.users.index');
    $trail->push(ucwords($user->name), route('user-management.users.show', $user));
});

// Home > Dashboard > User Management > Roles
Breadcrumbs::for('user-management.roles.index', function (BreadcrumbTrail $trail) {
    $trail->parent('user-management.index');
    $trail->push('Roles', route('user-management.roles.index'));
});

// Home > Dashboard > User Management > Roles > [Role]
Breadcrumbs::for('user-management.roles.show', function (BreadcrumbTrail $trail, Role $role) {
    $trail->parent('user-management.roles.index');
    $trail->push(ucwords($role->name), route('user-management.roles.show', $role));
});

// Home > Dashboard > User Management > Permission
Breadcrumbs::for('user-management.permissions.index', function (BreadcrumbTrail $trail) {
    $trail->parent('user-management.index');
    $trail->push('Permissions', route('user-management.permissions.index'));
});
