<?php

use App\Http\Controllers\Apps\PermissionManagementController;
use App\Http\Controllers\Apps\RoleManagementController;
use App\Http\Controllers\Apps\UserManagementController;
use App\Http\Controllers\SchoolController;
use App\Http\Controllers\DepartmentController;
use App\Http\Controllers\PositionController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\TransactionController;
use App\Http\Controllers\TeamTransactionController;
use App\Http\Controllers\ShiftManagerController;
use App\Http\Controllers\ShiftDetailsController;
use App\Http\Controllers\Auth\ChangePasswordController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::middleware(['auth', 'verified', 'bloom_notification'])->group(function () {

    Route::get('/', [DashboardController::class, 'index']);

    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard'); 
    Route::get('/schools/syncSchools', [SchoolController::class, 'syncSchools'])->name('syncSchools');
    Route::resource('/schools', SchoolController::class);  
    
    Route::get('/departments/syncDepartments', [DepartmentController::class, 'syncDepartments'])->name('syncDepartments');
    Route::resource('/departments', DepartmentController::class); 
    Route::get('/positions/syncPositions', [PositionController::class, 'syncPositions'])->name('syncPositions');
    Route::resource('/positions', PositionController::class); 

    Route::get('/transaction/UpdateTransactionsTime/{user_id}', [TransactionController::class, 'UpdateTransactionsTime'])->name('UpdateTransactionsTime');  
    Route::get('/transaction/myAttendance', [TransactionController::class, 'myAttendance'])->name('transactionMyAttendance');  
    Route::post('/transaction/myAttendanceSubmit', [TransactionController::class, 'myAttendanceSubmit'])->name('myAttendance.submit');    
    Route::get('/transaction/requestView', [TransactionController::class, 'requestView'])->name('transactionRequestView');    
    Route::get('/transaction/reportView', [TransactionController::class, 'reportView'])->name('transactionReportView');
    Route::get('/transaction/regularizeAttendance', [TransactionController::class, 'regularizeAttendance'])->name('regularizeAttendance');  
    Route::post('/transaction/submitApproveAttendance', [TransactionController::class, 'submitApproveAttendance'])->name('submitApproveAttendance.submit'); 
    
    Route::get('/team/dayAttendance', [TeamTransactionController::class, 'teamDayAttendance'])->name('teamDayAttendance');
    Route::get('/team/members', [TeamTransactionController::class, 'teamMembers'])->name('teamMembers'); 
    Route::get('/team/memberAttendance', [TeamTransactionController::class, 'teammemberAttendance'])->name('teamMemberAttendance');
    Route::get('/team/membersReport', [TeamTransactionController::class, 'teammemberReport'])->name('teammemberReport');

    
        
    Route::resource('shift_manager', ShiftManagerController::class)->middleware(['role:administrator']);
    Route::post('/post-default-shift-data', [ShiftManagerController::class, 'postDefaultShiftData']);   

    Route::get('change-password',[ChangePasswordController::class,'index'])->name('getChangePassword');
    Route::post('change-password',[ChangePasswordController::class,'changePassword'])->name('change.password');

    Route::middleware(['role:administrator'])->group(function () {
        Route::get('shift_details/{shift_info_id}', [ShiftDetailsController::class, 'index'])->name('shift_details.index');
        Route::get('shift_details/create/{shift_info_id}', [ShiftDetailsController::class, 'create'])->name('shift_details.create');
        Route::post('shift_details', [ShiftDetailsController::class, 'store'])->name('shift_details.store');
        Route::get('shift_details/{shift_detail}', [ShiftDetailsController::class, 'show'])->name('shift_details.show');
        Route::get('shift_details/{shift_detail}/edit', [ShiftDetailsController::class, 'edit'])->name('shift_details.edit');
        Route::put('shift_details/{shift_detail}', [ShiftDetailsController::class, 'update'])->name('shift_details.update');
        Route::patch('shift_details/{shift_detail}', [ShiftDetailsController::class, 'update'])->name('shift_details.update');
        Route::delete('shift_details/{shift_detail}', [ShiftDetailsController::class, 'destroy'])->name('shift_details.destroy');
    });
    


    Route::name('user-management.')->middleware(['role:administrator'])->group(function () {
        Route::get('/user-management/users/isLineManager/{user_id}', [UserManagementController::class, 'isLineManager'])->name('isLineManager');  
        Route::get('/user-management/users/assignManager/{user_id}', [UserManagementController::class, 'assignManager'])->name('assignManager');  
        Route::get('/user-management/users/assignManagerSubmit/{user_id}/{manager_id}', [UserManagementController::class, 'assignManagerSubmit'])->name('assignManagerSubmit');    
       
        Route::get('/user-management/users/syncEmployees', [UserManagementController::class, 'syncEmployees'])->name('syncEmployees');
        Route::get('/user-management/users/createEmployee', [UserManagementController::class, 'createEmployee'])->name('createEmployee');
        Route::post('/user-management/users/storeEmployee', [UserManagementController::class, 'storeEmployee'])->name('storeEmployee');
        Route::get('/user-management/users/editEmployee/{user_id}', [UserManagementController::class, 'editEmployee'])->name('editEmployee');
        Route::put('/user-management/users/updateEmployee/{user_id}', [UserManagementController::class, 'updateEmployee'])->name('updateEmployee');
        
        Route::resource('/user-management/users', UserManagementController::class)->except(['show']);
        Route::resource('/user-management/roles', RoleManagementController::class);
        Route::resource('/user-management/permissions', PermissionManagementController::class);
    });

    Route::get('/user-management/users/{user}', [UserManagementController::class, 'show'])->name('user-management.users.show');

});

Route::get('/error', function () {
    abort(500);
});

require __DIR__ . '/auth.php';
