<?php if (isset($component)) { $__componentOriginal1c2e2f4f77e507b499e79defc0d48b7e = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1c2e2f4f77e507b499e79defc0d48b7e = $attributes; } ?>
<?php $component = App\View\Components\DefaultLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('default-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\DefaultLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>

    <?php $__env->startSection('title'); ?>
        My Attendance
    <?php $__env->stopSection(); ?>

    <?php $__env->startSection('breadcrumbs'); ?>
        <?php echo e(Breadcrumbs::render('transactionMyAttendance')); ?>

    <?php $__env->stopSection(); ?>

    <!--begin::Row-->
    <div class="row g-5 g-xl-10 mb-5 mb-xl-10">

        <div class="d-flex justify-content-end mb-3">
            <div class="btn-group" role="group">
                <a href="<?php echo e(route('transactionMyAttendance', ['monthType' => 'previous'])); ?>" class="btn btn-secondary <?php echo e($monthType === 'previous' ? 'active' : ''); ?>">
                    Previous Month
                </a>
                <a href="<?php echo e(route('transactionMyAttendance', ['monthType' => 'current'])); ?>" class="btn btn-secondary <?php echo e($monthType === 'current' ? 'active' : ''); ?>">
                    Current Month
                </a>
            </div>
        </div>

        <div class="col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-md-5 mb-xl-10">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Punch-In Time</th>
                    <th>Punch-Out Time</th>
                    <th>Total Hours Worked</th>
                    <th>Action</th>
                    <th>Status</th>
                    <th>Comments</th>
                    <th>System</th>
                    <th>Permission In</th>	
                    <th>Permission Out</th>	
                    <th>Total Break Hours</th>	
                    <th>Shift Code</th>
                </tr>
            </thead>
            <tbody>
                <?php if($attendance): ?>
                    <?php $__currentLoopData = $attendance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date => $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php 
                            $displayRegularize = $record['status'] !== "Present" && $record['status'] !== "Rest Day" && $record['status'] !== "Pending" && $record['status'] !== "Approved" && $record['is_approved_leave'] !== 1;
                        ?>
                        <tr class="<?php echo e($record['status'] == 'Rest Day' ? 'table-success' : ($displayRegularize ? 'table-danger' : '')); ?>">

                            <td><?php echo e(helperformatDate($date, "d-m-Y (l)")); ?></td>
                            <td>
                                <?php if(isset($record['change_login_in']) && $record['login_time']): ?>
                                    <span data-bs-toggle="tooltip" data-bs-placement="top" title="<?php echo e(helperformatTime($record['change_login_in'])); ?>" style="border-bottom: 2px darkblue dotted;">
                                        <?php echo e(helperformatTime($record['login_time'])); ?>

                                    </span>
                                <?php else: ?>
                                    <span><?php echo e(helperformatTime($record['login_time']) ?? 'N/A'); ?></span>
                                <?php endif; ?>               
                            </td>

                            <td>
                                <?php if(isset($record['change_login_out']) && $record['logout_time']): ?>
                                    <span data-bs-toggle="tooltip" data-bs-placement="top" title="<?php echo e(helperformatTime($record['change_login_out'])); ?>" style="border-bottom: 2px darkblue dotted;">
                                        <?php echo e(helperformatTime($record['logout_time'])); ?>

                                    </span>
                                <?php else: ?>
                                    <span><?php echo e(helperformatTime($record['logout_time']) ?? 'N/A'); ?></span>
                                <?php endif; ?>               
                            </td>
                            
                            <td><?php echo e($record['hours_worked'] ?? 'N/A'); ?></td> 
                            <td>
                                <?php if($displayRegularize): ?>
                                    <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#attendanceModal" data-date="<?php echo e($date); ?>" data-punch_in="<?php echo e($record['login_time']); ?>"
                                    data-punch_out="<?php echo e($record['logout_time']); ?>">
                                    Regularize
                                    </button>
                                <?php endif; ?>
                            </td>       
                            <td><?php echo e($record['status'] ?? 'N/A'); ?></td>                  
                            <td><?php echo e($record['rejection_reason']); ?></td>
                            <td><?php echo e(($record['is_corrected']) ? 'Mod' : 'Sys'); ?></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <tr>
                        <td colspan="12" style="text-align: center;" >No data available in table</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>

        </div>
    </div>

    <div class="modal fade" id="attendanceModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Regularize Your Attendance</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="submitForm" method="POST" action="<?php echo e(route('myAttendance.submit')); ?>">
                    <div class="modal-body">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <label for="date" class="form-label">Date</label>
                            <input type="text" class="form-control" id="date" name="attendance_date" readonly style="background-color: #e9ecef; color: #6c757d;">
                        </div>

                        <!-- Radio Buttons -->
                        <div class="mb-3">
                            <label class="form-label">Modify Options</label><br>
                            <input type="radio" id="modify_in_time" name="regularization_type" value="in_time"> Modify In Time<br>
                            <input type="radio" id="modify_out_time" name="regularization_type" value="out_time"> Modify Out Time<br>
                            <input type="radio" id="modify_in_out_time" name="regularization_type" value="in_out_time"> Modify In/Out Time<br>
                            <input type="radio" id="request_approved_leave" name="regularization_type" value="approved_leave"> Request to mark as approved leave
                        </div>

                        <!-- Modify In Time Field -->
                        <div class="mb-3" id="modify_in_time_field">
                            <label for="punch_in" class="form-label">Modify In Time</label>
                            <input type="time" class="form-control" id="punch_in" name="punch_in"  step="1">
                        </div>

                        <!-- Modify Out Time Field -->
                        <div class="mb-3" id="modify_out_time_field">
                            <label for="punch_out" class="form-label">Modify Out Time</label>
                            <input type="time" class="form-control" id="punch_out" name="punch_out"  step="1">
                        </div>

                        <div class="mb-3">
                            <label for="reason" class="form-label">Reason</label>
                            <textarea class="form-control" id="reason" name="reason" required></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-sm btn-primary">Save changes</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <script type="text/javascript">

        document.addEventListener('DOMContentLoaded', function() {
            // Hide fields on load
            document.getElementById('modify_in_time_field').style.display = 'none';
            document.getElementById('modify_out_time_field').style.display = 'none';

            // Add event listeners to radio buttons
            document.getElementById('modify_in_time').addEventListener('change', function() {
                document.getElementById('modify_in_time_field').style.display = 'block';
                document.getElementById('modify_out_time_field').style.display = 'none';
                document.getElementById('reason').setAttribute('required', 'required');
            });

            document.getElementById('modify_out_time').addEventListener('change', function() {
                document.getElementById('modify_in_time_field').style.display = 'none';
                document.getElementById('modify_out_time_field').style.display = 'block';
                document.getElementById('reason').setAttribute('required', 'required');
            });

            document.getElementById('modify_in_out_time').addEventListener('change', function() {
                document.getElementById('modify_in_time_field').style.display = 'block';
                document.getElementById('modify_out_time_field').style.display = 'block';
                document.getElementById('reason').setAttribute('required', 'required');
            });

            document.getElementById('request_approved_leave').addEventListener('change', function() {
                document.getElementById('modify_in_time_field').style.display = 'none';
                document.getElementById('modify_out_time_field').style.display = 'none';
                document.getElementById('reason').removeAttribute('required');
            });
        });

		var attendanceModal = document.getElementById('attendanceModal');
        
        attendanceModal.addEventListener('show.bs.modal', function (event) {
            var button = event.relatedTarget
            var date = button.getAttribute('data-date');
            var punch_in = button.getAttribute('data-punch_in');
            var punch_out = button.getAttribute('data-punch_out');

            // Update the modal's content.
            var modalDate = attendanceModal.querySelector('#date');
            var modalPunchIn = attendanceModal.querySelector('#punch_in');
            var modalPunchOut = attendanceModal.querySelector('#punch_out');

            modalDate.value = date;
            modalPunchIn.value = punch_in;
            modalPunchOut.value = punch_out;
        })

	</script>

    <!--end::Row-->
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1c2e2f4f77e507b499e79defc0d48b7e)): ?>
<?php $attributes = $__attributesOriginal1c2e2f4f77e507b499e79defc0d48b7e; ?>
<?php unset($__attributesOriginal1c2e2f4f77e507b499e79defc0d48b7e); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1c2e2f4f77e507b499e79defc0d48b7e)): ?>
<?php $component = $__componentOriginal1c2e2f4f77e507b499e79defc0d48b7e; ?>
<?php unset($__componentOriginal1c2e2f4f77e507b499e79defc0d48b7e); ?>
<?php endif; ?>
<?php /**PATH /home/securetf/public_html/attendance/resources/views/pages/transaction/myAttendance.blade.php ENDPATH**/ ?>