<?php
namespace App\Helper;
use App\User;
use App\Model\Patient\Patient;
use App\Model\Patient\PatientCount;
use App\Model\Employee\Roleaccess;

class FormHelper
{

    public static function genreateStingPad($length, $invID) {
        $invID += 1;
        return str_pad($invID, $length, '0', STR_PAD_LEFT);
    }

    /*
    * Code-RoleId-UNIQID
    * Example AAH01
    */
    public static function generatingEmployeeId($role_id, $uniqid) {
        $code = \Config::get('formdata.code');
        return $code.$role_id.self::genreateStingPad(3,$uniqid);
    }

    /*
    * Code-RoleId-UNIQID
    * Example AAH01
    */
    public static function generatingPatientId() {
        //$code = \Config::get('formdata.code');
        //return 'P'.self::genreateStingPad(6,$uniqid);

        $year = date('Y');
        $pcnt = Patient::where('created_at', 'like', $year . '%')->count();

        if($pcnt == 0) {
            $patCnt = new PatientCount();
            $patCnt->year  = $year;
            $patCnt->pcount  = 1;
            $patCnt->save();
            return $year.'/1';
        } else {
            $pcntData = PatientCount::where('year', 'like', $year . '%')->first();
            $patCnt = PatientCount::find($pcntData->id);
            $patCnt->pcount  = $pcntData->pcount + 1;
            $patCnt->save();
            return $year.'/'.($pcntData->pcount + 1);
        }
    }

    /*
    * Code-RoleId-UNIQID
    * Example AAH01
    */
    public static function generatingBillReceipt($uniqid) {
        $code = \Config::get('formdata.code');
        return 'P'.self::genreateStingPad(4,$uniqid);
    }

    /*
    * Code-RoleId-UNIQID
    * Example AAH01
    */
    public static function generatingAdmissionId($uniqid) {
        $code = \Config::get('formdata.code');
        return $code.date('ymd').self::genreateStingPad(4,$uniqid);
    }

    /*
    * Code-RoleId-UNIQID
    * Example AAH01
    */
    public static function generatingBillingId($uniqid) {
        $code = \Config::get('formdata.code');
        return $code.'-B'.self::genreateStingPad(4,$uniqid);
    }

    /*
    * Code-RoleId-UNIQID
    * Example AAH01
    */
    public static function generatingSalesId($uniqid) {
        $code = \Config::get('formdata.code');
        return $code.'-PH'.self::genreateStingPad(4,$uniqid);
    }

    public static function bloodGroupById($bloodGroupId)
    {
        foreach (\Config::get('formdata.bloodGroup') as $bloodGroup) {
            if($bloodGroup['id'] == $bloodGroupId)
                return $bloodGroup['text'];
        }
    }
    
    public static function generatingPurchaseId($uniqid) {
        $code = \Config::get('formdata.code');
        return $code.'-P'.self::genreateStingPad(4,$uniqid);
    }    

    public static function statusBtn($text, $type = 'success')
    {
        $type_check = ['success','primary','info','danger','warning'];
        if(!in_array($type, $type_check))
            $type = 'warning'; //Default type when non-type is requested

        return '<button type="button" class="btn btn-'.$type.' btn-sm">'.$text.'</button>';
    }


    public static function bsTags($text)
    {
        $return_str = '';

        foreach (explode(',', $text) as $list) {
            $return_str .= '<span class="badge badge-primary">'.$list.'</span>';    
        }

        return $return_str;
    }

    public static function genderTxt($text)
    {
        $return_str = '';

        if($text == 'm') {
            return 'Male';
        } else if($text == 'f') {
            return 'Female';
        } 
        
        return '';
    }

    public static function roleName($role_id)
    {
        $return_str = '';

        if($role_id == 1) {
            return 'Admin';
        } else if($role_id == 2) {
            return 'Manager';
        } else if($role_id == 3) {
            return 'Sales';
        } else if($role_id == 4) {
            return 'User';
        } 
        
        return '';
    }

    public static function floorById($floorId)
    {
        foreach (\Config::get('formdata.floors') as $floor) {
            if($floor['id'] == $floorId)
                return $floor['text'];
        }
    } 

    public static function userName($user_id)
    {
        $user = User::find($user_id);
        if(empty($user))
            return 'No Name';
        else
            return $user->firstname.' '.$user->lastname;
    } 

    public static function patientUserName($patient_id)
    {
        $user = Patient::find($patient_id);
        if(empty($user))
            return 'No Name';
        else
            return $user->firstname.' '.$user->lastname;
    } 


    public static function getPaymentText($pay_id)
    {
        $payment = \Config::get('formdata.payment');
        
        foreach ($payment as $pay) {
            if($pay_id == $pay['id']) {
                return $pay['text'];
            }
        }

        return '';
    } 


    public static function getRoleAccess($role_id)
    {
        $roleAccess = Roleaccess::select('module_id')->where('role_id', $role_id)->get()->toArray();

        $access = [];

        foreach ($roleAccess as $key => $v) {
            $access[] =  $v['module_id'];
        }

        return $access;
    } 


    public static function isInArray($needle, $haystack) 
    {
        foreach ($needle as $stack) {
            if (in_array($stack, $haystack)) {
                return true;
            }
        }
        return false;
    }
    


    /**
     * Returns formatted number
     *
     * @param  float   $value
     * @param  integer $decimal
     *
     * @return string
     */
    public static function formatNumber($value, $decimal = 2)
    {
        if (false === filter_var($value, FILTER_VALIDATE_FLOAT)) {
            return $value;
        }

        return number_format($value, $decimal);
    }

    public static function getGstCessTotal($total, $gst, $isCessNeeded = true) 
    {
        $result = [];

        $total_tax = $gst;

        if($isCessNeeded && $gst > 5)
        {
            $total_tax += 1; 
        }

        $result['selling_price'] = round(($total * 100) / ($total_tax + 100),2);
        $result['gst'] = round( ($result['selling_price'] * ($gst / 100)) ,2);
        $result['cess'] = 0;

        if($isCessNeeded && $gst > 5)
        {
            $result['cess'] = round( ($result['selling_price'] * (1 / 100)) ,2);;
        }

        return $result;
    }


    public static function getAddress($address) {

        if(!empty($address)) {
            $template = '<table class="table table-responsive invoice-table table-borderless">
                        <tbody>
                            <tr><td>'.$address['name'].'</td></tr>
                            <tr><td>'.$address['add1'].'</td></tr>
                            <tr><td>'.$address['add2'].'</td></tr>
                            <tr><td>'.$address['phone'].'</td></tr>
                        </tbody></table>';
        } else {

            $address = \Config::get('formdata.address_m');

            $template = '<table class="table table-responsive invoice-table table-borderless">
            <tbody>
            <tr><td>'.$address['name'].'</td></tr>
            <tr><td>'.$address['add1'].'</td></tr>
            <tr><td>'.$address['add2'].'</td></tr>
            <tr><td>'.$address['phone'].'</td></tr>
            </tbody></table>';

            $address = \Config::get('formdata.address_p');
            $template .= '<table class="table table-responsive invoice-table table-borderless">
            <tbody>
            <tr><td>'.$address['name'].'</td></tr>
            <tr><td>'.$address['add1'].'</td></tr>
            <tr><td>'.$address['add2'].'</td></tr>
            <tr><td>'.$address['phone'].'</td></tr>
            </tbody></table>';
        }

        return $template;
    }

}