<?php

namespace App\Http\Controllers\Employee;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\Employee\Employee;
use App\User;

class EmployeeController extends Controller
{

    public function getIndex()
    {  
        return view('admin.employee.index');
    }

    public function postEmployeeList(Request $request) {

        $employees = User::orderBy('created_at' , 'desc')->limit($request['length'])->offset($request['start'])->get();

        $employee_count = User::count();
        $lemployees = $this->__prepareData($employees);

        $json_data = array(
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => $employee_count,
            "recordsFiltered" => $employee_count,
            "data"            => $lemployees
        );

        echo json_encode($json_data);
    }

    private function __prepareData($users) {

        $lusers = [];

        foreach ($users as $user) {

            $luser['id']  = $user->id;
            $luser['user_id']  = $user->id;
            $luser['email'] = $user->email;
            $luser['firstname'] = $user->firstname;
            $luser['lastname'] = $user->lastname;
            $luser['address'] = $user->address;
            $luser['phnumber'] = $user->phnumber;
            $luser['mobile'] = $user->mobile;
            $luser['dob'] = $user->dob;
            $luser['sex'] = \FormHelper::genderTxt($user->sex);
            $luser['sex_id'] = $user->sex;
            $luser['bloodgroup'] = \FormHelper::bloodGroupById($user->bloodgroup);
            $luser['bloodgroup_id'] = $user->bloodgroup;

            if($user->status == 1) 
                $fdata = \FormHelper::statusBtn('Active','success');
            else 
                $fdata = \FormHelper::statusBtn('Inactive','danger');
            $luser['status'] = $fdata;
            $luser['status_id'] = $user->status;

            if(!empty($user->profilepic)) {
                $img_url = \URL::to('/').$user->profilepic;
                $luser['profilepic'] = '<br><img width="50" height="50" src="'.$img_url.'"><br>';
            } else {
                $luser['profilepic'] = '<span>No Image Added</span>';
            }

            $luser['role'] = \FormHelper::roleName($user->role_id);
            $luser['role_id'] = $user->role_id;

            $editUrl = \URL::to('/employee/edit/').'/'.$user->id;
            $deleteUrl =  \URL::to('/employee/delete/').'/'.$user->id;

            $luser['action'] = '<a title="Edit Employee Details" href="'.$editUrl.'" class="btn btn-sm btn-warning"><i class="fas fa-edit"></i></a><a style="margin-left:4px" title="Delete Employee Details" href="'.$deleteUrl.'" class="btn btn-sm btn-danger"><i class="fas fa-trash-alt"></i></a>';

            $lusers[] = $luser;
        }

        return $lusers;
    }

    public function create(Request $request)
    {
        $bloodGroup = json_encode(\Config::get('formdata.bloodGroup'));
        $roles = json_encode(\Config::get('formdata.roles'));

        return view('admin.employee.create' , ['roles' => $roles, 'bloodGroup' => $bloodGroup]);
    }


    public function show()
    {
        $employee = Employee::orderBy('created_at' , 'desc')->paginate(50);
        return view('admin.employee' , ['employees' => $employee]);
    }

    public function save(Request $request) 
    {
        $input = $request->all();
        $userCnt = User::count();

        $user = new User();
        //$user->name = $request['firstname'].' '.$request['lastname'];
        $role_id = $request['roles'];

        $user->code = \FormHelper::generatingEmployeeId($role_id, $userCnt);

        $user->password =  bcrypt(\Config::get('formdata.default_password'));
        $user->email = $request['email'];
        $user->role_id = $role_id;
        $user->firstname = $request['firstname'];
        $user->lastname = $request['lastname'];
        $user->address = $request['address'];
        $user->phnumber = $request['phnumber'];
        $user->mobile = $request['mobilenumber'];
        $user->dob = date('Y-m-d',strtotime($request['dob']));
        $user->sex = $request['sex'];
        $user->bloodgroup = $request['bloodgroup'];
        $user->status = $request['status'];

        if($request->hasFile('profilepic')) {            
            $imageName = time().'.'.request()->profilepic->getClientOriginalExtension();
            request()->profilepic->move(public_path('images').'/employees', $imageName);
            $user->profilepic = '/images/employees/'.$imageName;
        }

        if($user->save()) {
            \DB::commit();
            $ret_data = ['success' => 'Insert Successfully'];
        } else {
            \DB::rollback();
            $ret_data = ['fail' => 'Insert Failed'];
        }

        return redirect()->back()->with($ret_data);
    }

    public function edit($employee_id)
    {
        $bloodGroup = json_encode(\Config::get('formdata.bloodGroup'));
        $roles = json_encode(\Config::get('formdata.roles'));

        $employee = User::where('id',$employee_id)->get();
        $lemployee = $this->__prepareData($employee);

        if(!empty($lemployee))
            $lemployee = $lemployee[0];

        return view('admin.employee.edit', ['employee' => $lemployee,'roles' => $roles, 'bloodGroup' => $bloodGroup]);
    }



    public function update(Request $request)
    {
        $input = $request->all();

        $user = User::find($request['employee_id']);
        $user->email = $request['email'];
        $user->role_id = $request['roles'];
        $user->firstname = $request['firstname'];
        $user->lastname = $request['lastname'];
        $user->address = $request['address'];
        $user->phnumber = $request['phnumber'];
        $user->mobile = $request['mobilenumber'];
        $user->dob = date('Y-m-d',strtotime($request['dob']));
        $user->sex = $request['sex'];
        $user->bloodgroup = $request['bloodgroup'];
        $user->status = $request['status'];

        if($request->hasFile('profilepic')) {            
            $imageName = time().'.'.request()->profilepic->getClientOriginalExtension();
            request()->profilepic->move(public_path('images').'/employees', $imageName);
            $user->profilepic = '/images/employees/'.$imageName;
        }
        
        $user->save();

        return redirect()->back()->with(['success' => 'Updated Successfully'] );
    }

    public function delete($id)
    {
        $employee = User::find($id);

        if(!$employee){
            return redirect()->route('employee.index')->with(['fail' => 'Page not found !']);
        }
        $employee->delete();
        return redirect()->route('employee.index')->with(['success' => 'Deleted Successfully.']);
    }

   
}