<?php

namespace App\Http\Controllers\Inventory;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\Comment;

class CommentController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'body' => 'required',
            'quotation_id' => 'required'
        ]);

        $input = $request->all();
        $input['user_id'] = auth()->user()->id;
        Comment::create($input);
        
        return back();
    }
}