<?php

namespace App\Http\Controllers\Inventory;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\Customer;

class CustomerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $rows = Customer::orderBy('id' , 'desc')->get();

        $total = Customer::count();

        foreach ($rows as $row) {

            $editUrl = \URL::to('/customer/edit/').'/'.$row->id;
            $deleteUrl =  \URL::to('/customer/destroy/').'/'.$row->id;

            $row->action = '<a title="Edit customer Details" href="'.$editUrl.'" class="btn btn-sm btn-warning"><i class="fas fa-edit"></i></a><a style="margin-left:4px" title="Delete customer Details" href="'.$deleteUrl.'" class="btn btn-sm btn-danger"><i class="fas fa-trash-alt"></i></a>';
        }        

        $json_data = array(
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => $total,
            "recordsFiltered" => $total,
            "data"            => $rows
        );

        echo json_encode($json_data);
    }

    public function view()
    {
        return view('inventory.customer.view');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('inventory.customer.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            
            Customer::create($request->all());

            $messageType = 1;
            $message = "Customer created successfully !";

        } catch(\Illuminate\Database\QueryException $ex){  
            $messageType = 2;
            $message = "Customer creation failed !";  
            
            \Log::error('Customer creation failed: ' . $ex->getMessage());
        }

        return redirect(url("/customer/view"))->with('messageType',$messageType)->with('message',$message);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        dd($id);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $customer = Customer::find($id);

        return view('inventory.customer.edit')->with('customer',$customer);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {

            $customer = Customer::find($id);
            $customer->update($request->all());

            $messageType = 1;
            $message = "Customer ".$customer->customer_name." details updated successfully !";

        } catch(\Illuminate\Database\QueryException $ex){  
            $messageType = 2;
            $message = "Customer updation failed !";
        }

        return redirect(url("/customer/view"))->with('messageType',$messageType)->with('message',$message);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            
            $customer = Customer::find($id);
            $customer->delete();    

            $messageType = 1;
            $message = "Customer ".$customer->customer_name." details deleted successfully !";

        } catch(\Illuminate\Database\QueryException $ex){  
            $messageType = 2;
            $message = "Customer deletion failed !";
        }
        
        return redirect(url("/customer/view"))->with('messageType',$messageType)->with('message',$message);
    }
}
