<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;

class UserProfileController extends Controller
{
    public function index() {
    	$user = User::find(\Auth::id());
    	return view('admin.profile.index',['user' => $user]);
    }

    public function edit() {
    	$user = User::find(\Auth::id());
    	return view('admin.profile.edit',['user' => $user]);
    }

    public function update(Request $request) {

    	$input = $request->all();

    	$user = User::find($request['user_id']);
        $user->name = $request['firstname'].' '.$request['lastname'];
        $user->firstname = $request['firstname'];
        $user->lastname = $request['lastname'];
        $user->address = $request['address'];
        $user->phnumber = $request['phnumber'];
        $user->mobile = $request['mobilenumber'];
        $user->dob = date('Y-m-d',strtotime($request['dob']));

        if($request->hasFile('profilepic')) {            
            $imageName = time().'.'.request()->profilepic->getClientOriginalExtension();
            request()->profilepic->move(public_path('images').'/doctors', $imageName);
            $user->profilepic = '/images/doctors/'.$imageName;
        }
        
        $user->save();

        return redirect()->back()->with(['success' => 'Updated Successfully'] );

    }

    public function changePassword() {
        $user = User::find(\Auth::id());
        return view('admin.profile.changePassword',['user' => $user]);
    }

    public function updatePassword(Request $request) {

        $input = $request->all();

        $this->validate($request , [
            'password' => 'required',
            'password_confirmation' => 'required|same:password',     
        ]);

        $user = User::find($request['user_id']);
        $user->password = \Hash::make($request['password']);        
        $user->save();

        return redirect()->back()->with(['success' => 'Updated Successfully'] );

    }

    

    
}
