<?php
namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class QuotationItem extends Model
{
    use SoftDeletes;
    
    protected $fillable = [
        'name',
        'description',
        'quantity',
        'unit',
        'price',
        'quotation_id',
        'product_id',
        'total'
    ];

    protected $casts = [
        'price' => 'decimal',
        'total' => 'decimal',
        'quantity' => 'integer'
    ];

    public function quotation()
    {
        return $this->belongsTo(Quotation::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
