<?php

use Illuminate\Database\Seeder;

class RoleSeeder extends Seeder
{
	/**
	 * Run the database seeds.
	 *
	 * @return void
	 */
	public function run()
	{
		$insertData[] = [
			'name' => 'admin',
			'display_name' => 'Admin',
			'description' => 'Full permission'
		];
		$insertData[] = [
			'name' => 'manager',
			'display_name' => 'Manager',
			'description' => 'Can create and manage all Quotation'
		];
		$insertData[] = [
			'name' => 'Sales',
			'display_name' => 'Sales',
			'description' => 'Can create and manage thier Quotation'
		];
		$insertData[] = [
			'name' => 'User',
			'display_name' => 'User',
			'description' => 'View only role'
		];

		DB::table('roles')->insert($insertData);

		$insertData = [];

		$insertData[] = [
			'can_see' => 1,
			'can_edit' => 1,
			'can_update' => 1,
			'can_delete' => 1,
			'role_id' => 1,
			'module_id' => 1
		];
		$insertData[] = [
			'can_see' => 1,
			'can_edit' => 1,
			'can_update' => 1,
			'can_delete' => 1,
			'role_id' => 1,
			'module_id' => 2
		];
		$insertData[] = [
			'can_see' => 1,
			'can_edit' => 1,
			'can_update' => 1,
			'can_delete' => 1,
			'role_id' => 1,
			'module_id' => 3
		];

		DB::table('roleaccesses')->insert($insertData);
	}
}

