@extends('layouts.app')

@section('header')

<style type="text/css">
  td.details-control {
    background: url('../images/details_open.png') no-repeat center center;
    cursor: pointer;
}
tr.details td.details-control {
    background: url('../images/details_close.png') no-repeat center center;
}
</style>

<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Employee</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="{{ \URL::to('/')}}">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="#">Employee</a>
                </li>
            </ul>
        </div>
    </div>    
</div>

<div class="page-body">
    <div class="row">
        <div class="col-md-12">
            <a href="{{ URL::to('employee/create') }}" class="btn btn-primary btn-sm float-right"><i class="fas fa-plus-circle"></i> Add Employee</a>   
        </div>
    </div>
</div>


@endsection
@section('content')

<table id="dt-employee" class="table table-striped table-bordered" style="width:100%;">
    <thead>
        <tr>
            <th></th>
            <th>Email</th>
            <th>First name</th>
            <th>Last name</th>
            <th>Mobile</th>
            <th>Role</th>
            <th>Status</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
      
    </tbody>
</table>



@endsection


@section('scripts')
@include('layouts.datatables_only_files')

<script type="text/javascript">

function format ( d ) {
    return 'Address       : '+d.address+'<br>'+
           'Education     : '+d.firstname+'<br>'+
           'Pic           : '+d.profilepic+'<br>'+
           'Sex           : '+d.sex+'<br>'+
           'Blood Group   : '+d.bloodgroup+'<br>'+
           'Date of Birth : '+d.dob+'<br>';
}
 
$(document).ready(function() {
    var dt = $('#dt-employee').DataTable( {
        dom: 'Bfrtip',
        buttons: [
              'excel', 'pdf', 'print'
          ],
        "processing": true,
        "serverSide": true,
        "ajax":{              
                url : "/employee/list",
                type: "POST",
                data:{_token: '<?php echo csrf_token(); ?>'},
                async: false,
                error: function(){
                    $(".unit-totals-grid-error").html("");
                    $("#unit-totals-grid").append(
                        '<tbody class="unit-totals-grid-error"><tr><th colspan="32">No data found in the server</th></tr></tbody>'
                    );
                    $("#unit-log-grid_processing").css("display","none"); 
                }
        },
        "columns": [
            {
                "class":          "details-control",
                "orderable":      false,
                "data":           null,
                "defaultContent": ""
            },
            { "data": "email" },
            { "data": "firstname" },
            { "data": "lastname" },
            { "data": "mobile" },
            { "data": "role" },            
            { "data": "status" },
            { "data": "action" }
        ],
        "order": []
    } );
 
    // Array to track the ids of the details displayed rows
    var detailRows = [];
 
    $('#dt-employee tbody').on( 'click', 'tr td.details-control', function () {
        var tr = $(this).closest('tr');
        var row = dt.row( tr );
        var idx = $.inArray( tr.attr('id'), detailRows );
 
        if ( row.child.isShown() ) {
            tr.removeClass( 'details' );
            row.child.hide();
 
            // Remove from the 'open' array
            detailRows.splice( idx, 1 );
        }
        else {
            tr.addClass( 'details' );
            row.child( format( row.data() ) ).show();
 
            // Add to the 'open' array
            if ( idx === -1 ) {
                detailRows.push( tr.attr('id') );
            }
        }
    } );
 
    // On each draw, loop over the `detailRows` array and show any child rows
    dt.on( 'draw', function () {
        $.each( detailRows, function ( i, id ) {
            $('#'+id+' td.details-control').trigger( 'click' );
        } );
    } );
} );

</script>








@endsection

