@extends('layouts.app')

@section('header')

<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>My Profile</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="{{ \URL::to('/')}}">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="#">Profile</a>
                </li>
            </ul>
        </div>
    </div>    
</div>

@endsection
@section('content')



<div class="col-md-12">
    <div class="card user-card-full">
        <div class="row m-l-0 m-r-0">
            <div class="col-sm-4 bg-c-lite-green user-profile">
                <div class="card-block text-center text-white">
                    <div class="m-b-25">
                        <img src="{{ (!empty($user->profilepic) ? $user->profilepic :  \URL::asset('images/User-Profile-Image.png')  ) }}" height="100" width="100" class="img-radius" alt="User-Profile-Image">
                    </div>
                    <h6 class="f-w-600">{{ $user->firstname.' '.$user->lastname }}</h6>
                    <p>Role: {{ \FormHelper::roleName($user->role_id) }}</p>
                    <a title="Edit Profile" href="{{ \URL::to('/profile/edit') }}">
                        <i class="fas fa-edit"></i>
                    </a>
                    <!-- <a href="" title="Print My Profile"><i class="fas fa-print"></i></a> -->
                </div>
            </div>
            <div class="col-sm-8">
                <div class="card-block">
                    <h6 class="m-b-20 p-b-5 b-b-default f-w-600">Information</h6>
                    <div class="row">
                        <div class="col-sm-6">
                            <p class="m-b-10 f-w-600">ID</p>
                            <h6 class="text-muted f-w-400">{{ $user->code }}</h6>
                        </div>
                        <div class="col-sm-6">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6">
                            <p class="m-b-10 f-w-600">First Name</p>
                            <h6 class="text-muted f-w-400">{{ $user->firstname }}</h6>
                        </div>
                        <div class="col-sm-6">
                            <p class="m-b-10 f-w-600">Last Name</p>
                            <h6 class="text-muted f-w-400">{{ $user->lastname }}</h6>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6">
                            <p class="m-b-10 f-w-600">Email</p>
                            <h6 class="text-muted f-w-400">{{ $user->email }}</h6>
                        </div>
                        <div class="col-sm-6">
                            <p class="m-b-10 f-w-600">Mobile</p>
                            <h6 class="text-muted f-w-400">{{ $user->mobile }}</h6>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6">
                            <p class="m-b-10 f-w-600">Date of Birth</p>
                            <h6 class="text-muted f-w-400">{{ $user->dob }}</h6>
                        </div>
                        <div class="col-sm-6">
                            <p class="m-b-10 f-w-600">Status</p>
                            <h6 class="text-muted f-w-400">
                                @if($user->status == 1)
                                    {!! \FormHelper::statusBtn('Active','success') !!}
                                @else
                                    {!! \FormHelper::statusBtn('Inactive','danger') !!}
                                @endif
                            </h6>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <p class="m-b-10 f-w-600">Address</p>
                            <h6 class="text-muted f-w-400">{{ $user->address }}</h6>
                        </div>
                    </div>                    
                </div>
            </div>
        </div>
    </div>
</div>

@endsection


@section('scripts')

@endsection

