@extends('layouts.app')

@section('header')


<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Role Access</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="{{ \URL::to('/')}}">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="{{ \URL::to('/role') }}">Role</a>
                <li class="breadcrumb-item"><a href="#">Role Access</a>
                </li>
            </ul>
        </div>
    </div>    
</div>

<div class="page-body">
    <div class="row">
        <div class="col-md-12">
            <p> Role: {{ $role->name }}</p>   
        </div>
    </div>
    <form method="post" action="{{ \URL::to('/roleaccesses/update') }}" >

        {{ csrf_field() }}
        <input type="hidden" name="role_id" value="{{ $role->id }}">

        @foreach(array_chunk($allModules,3,true) as $partModules)
            <div class="row">
            @foreach($partModules as $mkey => $mvalue)
                <div class="col-xs-4 col-md-4">
                    <label><b>{{ $mkey }}</b></label>
                    @foreach($mvalue as $makey => $mavalue)
                        <div class="checkbox">
                            <label>
                                <input type="checkbox" name= "{{ $mavalue['text'].'$'.$mavalue['id']  }}" {{
                                ($mavalue['access']) ? 'checked' : '' }} > {{ $mavalue['text'] }}
                            </label>
                        </div>
                    @endforeach
                </div>
            @endforeach
            </div>
            <hr>
        @endforeach

         <div class="row">
            <label class="col-sm-2"></label>
            <div class="col-sm-10">
                <button type="submit" class="btn btn-primary m-b-0">Update</button>
            </div>
        </div>

    </form>



</div>

@endsection
@section('content')



