<!DOCTYPE html>
<html lang="en">

<head>
    <title>{!! \Lang::get('genric.title') !!} </title>
    <!-- HTML5 Shim and Respond.js IE10 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 10]>
      <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
      <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
      <![endif]-->
    <!-- Meta -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="description" content="#">
    <meta name="keywords" content="{!! \Lang::get('genric.keywords') !!}">
    <meta name="author" content="#">
    <!-- Favicon icon -->
    <link rel="icon" href="../files/assets/images/favicon.ico" type="image/x-icon">
    <!-- Google font--><link href="https://fonts.googleapis.com/css?family=Open+Sans:400,600,800" rel="stylesheet">
    <!-- Required Fremwork -->
    <link rel="stylesheet" type="text/css" href="{{ \URL::asset('css/bootstrap.min.css') }}">
    <!-- themify-icons line icon -->
    <link rel="stylesheet" type="text/css" href="{{ \URL::asset('css/themify-icons.css') }}">
    <!-- ico font -->
    <link rel="stylesheet" type="text/css" href="{{ \URL::asset('css/icofont.css') }}">
    
    <style>
        body, html {
            height: 100%;
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
        }
        .full-screen {
            height: 100vh; /* Full height of the viewport */
            width: 100vw; /* Full width of the viewport */
            display: flex;
        }
        .bg-image {
            /* Adjust height for the image section */
            height: 100%;
            /* Center and scale the image nicely */
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
            /* Position relative to the viewport */
            position: relative;
            overflow: hidden;
        }
        .overlay {
            position: absolute;
            top: 0;
            bottom: 0;
            left: 0;
            right: 0;
            background-color: rgba(0, 0, 0, 0.6); /* Adjust the overlay color and opacity */
        }
        .login-form-container {
            height: 100%;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .login-form {
            background-color: #ffffff;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1); /* Optional: Add shadow for the form */
            width: 80%; /* Adjust the width of the form */
        }
    </style>
</head>

<body>

<div class="full-screen">
    <div class="row no-gutters">
        <!-- Section with background image -->
        <div class="col-md-6 bg-image" style="background-image: url({{ \URL::asset('images/logo_left_image.png') }});">
            <div class="overlay"></div>
            <div class="text-center text-white">
                <!-- <h1>Welcome to Our Website</h1>
                <p>Enter your credentials to access your account.</p> -->
            </div>
        </div>

        <!-- Section with login form -->
        <div class="col-md-6">
            <div class="login-form-container">
                <div class="login-form">                                   
                    <form class="md-float-material form-material" method="post" action="{{ url('/login') }}">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">  
                        <div class="row m-b-20">
                            <div class="col-md-12">
                                <div class="text-center">
                                    <img style="width: 100%" src="{{ \URL::asset('images/logo.png') }}" alt="{!! \Lang::get('genric.name') !!}">
                                </div>
                            </div>
                        </div>
                        <h3 style="font-weight:bold">Login</h3>                        
                        @if ($errors->any())
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-danger" role="alert">
                                        {{ $error }}
                                </div>
                            @endforeach
                        @endif
                        <div class="form-group form-primary">
                            <input type="text" name="email" class="form-control" required="" placeholder="Your Email Address">
                            <span class="form-bar"></span>
                        </div>
                        <div class="form-group form-primary">
                            <input type="password" name="password" class="form-control" required="" placeholder="Password">
                            <span class="form-bar"></span>
                        </div>
                        <div class="row m-t-30">
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary btn-md btn-block waves-effect waves-light text-center m-b-20" style="background-color:#aa1f23">Login</button>
                            </div>
                        </div>
                        <hr/>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
    
<!-- Required Jquery -->
<script type="text/javascript" src="{{ \URL::asset('js/jquery.min.js') }}"></script>
<script type="text/javascript" src="{{ \URL::asset('js/jquery-ui.min.js') }}"></script>
<script type="text/javascript" src="{{ \URL::asset('js/popper.min.js') }}"></script>
<script type="text/javascript" src="{{ \URL::asset('js/bootstrap.min.js') }}"></script>

</body>

</html>
