@extends('layouts.app')


@section('header')
<div class="card borderless-card">
  <div class="card-block primary-breadcrumb">
    <div class="breadcrumb-header">
      <h5>Stock Category</h5>
    </div>
    <div class="page-header-breadcrumb">
      <ul class="breadcrumb-title">
        <li class="breadcrumb-item">
          <a href="{{ \URL::to('/')}}">
            <i class="fas fa-home"></i>
          </a>
        </li>
        <li class="breadcrumb-item"><a href="{{ \URL::to('category/view') }}">List Stock Category</a>
        </li>
        <li class="breadcrumb-item"><a href="#">Add Stock Category</a>
        </li>
      </ul>
    </div>
  </div>
</div>

@endsection


@section('content')
<div class="card">
  <div class="card-header">
    <h5>Add Stock Category</h5>
  </div>
  <div class="card-block">
    <form class="form-horizontal create_category" role="form" method="POST" action="{{ url('/category/store') }}">

      {{ csrf_field() }}

      <div class="box-body">
        <div class="row">
          <div class="col-sm-12">
            <div class="form-group">
              <label>Category Name</label><br>
              <input type="text" class="form-control" name="category_name" placeholder="">
            </div>
          </div>
        </div>

        <div class="row">
          <div class="col-sm-12">
            <div class="panel panel-primary">
              <div class="panel-heading">
                Measures & Units
              </div>
              <div class="panel-body">
                <div class="form-group">
                  @foreach($details as $key => $val)
                  <input type="checkbox" class="measures_check" name="measure_id[]" value="{{ $val->measure_id }}" required=""> {{ $val->name }} <br>
                  <div class="form-group measure_id_{{ $val->measure_id }}" style="display: none;"><br>
                    @foreach($val->unit as $key1 => $val1)
                    @if ($loop->first)
                    &nbsp;&nbsp;&nbsp;&nbsp;
                    @endif

                    <input type="radio" class="measure_unit_{{ $val->measure_id }}" name="uom_id_{{ $val->measure_id }}" disabled required="" value="{{ $val1->uom_id }}">
                    <span>&nbsp;{{ $val1->name }} &nbsp;&nbsp;</span>

                  @if ($loop->last)
                  <br><br>
                  @endif
                  @endforeach
                </div>
                @endforeach
              </div>
            </div>
          </div>

        </div>

      </div>

    </div>
    <!-- /.box-body -->

    <div class="box-footer">
      <button type="reset" class="btn btn-danger pull-left">Reset</button>
      <button type="submit" class="btn btn-primary pull-right"><i class="fa fa-plus"></i> Add</button>
    </div>
  </form>
</div>
</div>  
<!-- /.content -->
@endsection
