@extends('layouts.app')

@section('header')
<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Add Customer</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="{{ \URL::to('/')}}">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="{{ \URL::to('category/view') }}">List Customer</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Add Customer</a>
                </li>
            </ul>
        </div>
    </div>
</div>

@endsection


@section('content')


<div class="card">
  <div class="card-header">
    <h5>Add Customer</h5>
  </div>
  <div class="card-block">
    <form class="form-horizontal create_customer" role="form" method="POST" action="{{ url('/customer/store') }}">

            {{ csrf_field() }}

            <div class="box-body">

              <div class="row">
                
                <div class="col-sm-6">
                  <div class="form-group">
                    <label>Customer Name</label><br>
                    <input type="text" class="form-control" name="name" placeholder="Full name">
                  </div>
                </div>

                <div class="col-sm-6">
                  <div class="form-group">
                    <label>E-mail</label>
                    <input type="email" class="form-control" name="email" placeholder="abc@xyz.com">
                  </div>
                </div>

              </div>

              <div class="row">
                
                <div class="col-sm-12">
                  <div class="form-group">
                    <label>Address</label><br>
                    <textarea class="form-control" placeholder="Enter current address ... " name="address"></textarea>
                  </div>
                </div>

              </div>

              <div class="row">
                
                <div class="col-sm-6">
                  <div class="form-group">
                    <label>Contact Mobile</label><br>
                    <input type="text" name="contact1" class ='form-control' placeholder = '' maxlength="11" minlength="10"/>
                  </div>
                </div>

                <div class="col-sm-6">
                  <div class="form-group">
                    <label>Alternate Mobile</label><br>
                    <input type="text" name="contact2" class ='form-control' placeholder = '' maxlength="11" minlength="10"/>
                  </div>
                </div>

              </div>

            </div>
            <!-- /.box-body -->

            <div class="box-footer">
              <button type="reset" class="btn btn-danger pull-left">Reset</button>
              <button type="submit" class="btn btn-primary pull-right"><i class="fa fa-plus"></i> Add</button>
            </div>
    </form>
  </div>
</div>
@endsection
