@extends('layouts.app')

@section('header')
<div class="card borderless-card">
  <div class="card-block primary-breadcrumb">
    <div class="breadcrumb-header">
      <h5>Customer</h5>
    </div>
    <div class="page-header-breadcrumb">
      <ul class="breadcrumb-title">
        <li class="breadcrumb-item">
          <a href="{{ \URL::to('/')}}">
            <i class="fas fa-home"></i>
          </a>
        </li>
        <li class="breadcrumb-item"><a href="#">View Customer</a>
        </li>
      </ul>
    </div>
  </div>
</div>

<div class="page-body">
    <div class="row">
        <div class="col-md-12">
            <a href="{{ URL::to('customer/create') }}" class="btn btn-primary btn-sm float-right"><i class="fas fa-plus-circle"></i> Add Customer</a>   
        </div>
    </div>
</div>

@endsection

@section('content')

<div class="table-responsive"> 
  <table id="view-customer" class="table table-striped table-bordered" style="width:100%;">
    <thead>
      <tr>
          <th>Customer ID</th>
          <th>Name</th>
          <th>E-Mail</th>
          <th>Address</th>
          <th>Mobile</th>
          <th>Alternate Mobile</th>
          <!-- <th>Balance</th> -->
          <th>Action</th>
      </tr>
    </thead>
  </table>
</div>
@endsection


@section('scripts')
@include('layouts.datatables_only_files')


<script type="text/javascript">

$(document).ready(function() {
    var dt = $('#view-customer').DataTable( {
        dom: 'Bfrtip',
        buttons: [
              'excel', 'pdf', 'print'
          ],
        "processing": true,
        "serverSide": true,
        "ajax":{              
                url : "/customer/index",
                type: "GET",
                data:{_token: '<?php echo csrf_token(); ?>'},
                async: false,
                error: function(){
                    $(".unit-totals-grid-error").html("");
                    $("#unit-totals-grid").append(
                        '<tbody class="unit-totals-grid-error"><tr><th colspan="32">No data found in the server</th></tr></tbody>'
                    );
                    $("#unit-log-grid_processing").css("display","none"); 
                }
        },
        "columns": [
            { "data": "id" },
            { "data": "name" },
            { "data": "email" },
            { "data": "address" },
            { "data": "contact1" },
            { "data": "contact2" },
           // { "data": "balance" },
            { "data": "action" }
        ],
        "order": []
    } );
 

});

</script>

@endsection
