@extends('layouts.app')

@section('header')
<div class="card borderless-card">
  <div class="card-block primary-breadcrumb">
    <div class="breadcrumb-header">
      <h5>View Stock Availability</h5>
    </div>
    <div class="page-header-breadcrumb">
      <ul class="breadcrumb-title">
        <li class="breadcrumb-item">
          <a href="{{ \URL::to('/')}}">
            <i class="fas fa-home"></i>
          </a>
        </li>
        <li class="breadcrumb-item"><a href="#">View Stock Availability</a>
        </li>
      </ul>
    </div>
  </div>
</div>

@endsection


@section('content')
<div class="table-responsive" style="width:99%;margin-left:5px">
  <table id="view-availability" class="table table-striped table-bordered" style="width:100%;">
    <thead>
      <tr>
        <th>Stock ID</th>
        <th>Stock Category</th>
        <th>Stock Category</th>
        <th>Purchase Cost (₹)</th>
        <th>Selling Cost (₹)</th>
        <th>Available Quantity</th>
        <th>Machiyil Available Quantity</th>
        <th>Padichal Available Quantity</th>
      </tr>
    </thead>
  </table>
</div>
@endsection


@section('scripts')

@include('layouts.datatables_only_files')
<script type="text/javascript">

$(document).ready(function() {
    var dt = $('#view-availability').DataTable( {
        dom: 'Bfrtip',
        buttons: [
              'excel', 'pdf', 'print'
          ],
        "processing": true,
        "serverSide": true,
        "ajax":{              
                url : "/stock/get/availability",
                type: "GET",
                data:{_token: '<?php echo csrf_token(); ?>'},
                async: false,
                error: function(){
                    $(".unit-totals-grid-error").html("");
                    $("#unit-totals-grid").append(
                        '<tbody class="unit-totals-grid-error"><tr><th colspan="32">No data found in the server</th></tr></tbody>'
                    );
                    $("#unit-log-grid_processing").css("display","none"); 
                }
        },
        "columns": [
            { "data": "stock_id" },
            { "data": "stock_name" },
            { "data": "category_name" },
            { "data": "purchase_cost" },
            { "data": "selling_cost" },
            { "data": "stock_quantity" },
            { "data": "b1_stock_quantity" },
            { "data": "b2_stock_quantity" }
        ],
        "order": []
    } );
 

});

</script>

@endsection

