@extends('layouts.app')

@section('header')
<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Edit Product</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="{{ \URL::to('/')}}">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="{{ \URL::to('product/view') }}">List Product</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Edit Product</a>
                </li>
            </ul>
        </div>
    </div>
</div>

@endsection

@section('content')

<div class="card">
  <div class="card-header">
    <h5>Edit Product</h5>
  </div>
  <div class="card-block">
    <form class="form-horizontal create_product" role="form" method="POST" action="{{ url('/product/update/' . $product->id) }}">

      {{ csrf_field() }}

      <div class="box-body">
      
      <input type="hidden" name="id" value="{{ $product->id }}">

        <div class="row">
          <div class="col-sm-12">
            <div class="form-group">
              <label>Name</label><br>
              <input type="text" class="form-control" name="name"  value="{{ $product->name }}">
            </div>
          </div>
        </div> 

        <div class="row">
          <div class="col-sm-12">
            <div class="form-group">
              <label>Description</label><br>
              <textarea id="summernote" class="form-control" name="description">{{ $product->description }}</textarea>
            </div>
          </div>
        </div> 

        <div class="row">
          <div class="col-sm-4">
            <div class="form-group">
              <label>Unit</label><br>
              <select class="form-control" name="unit">
                @foreach($measurements as $g)
                  @if($product->unit == $g['text'])
                    <option value="{{ $g['text'] }}" selected>{{ ucfirst($g['text']) }}</option>
                  @else
                    <option value="{{ $g['text'] }}">{{ ucfirst($g['text']) }}</option>
                  @endif                  
                @endforeach
              </select>
            </div>
          </div>          
        </div>

        <div class="row">
          <div class="col-sm-4">
            <div class="form-group">
              <label>Price</label><br>
              <input type="text" class="form-control" name="price" placeholder="0.0" value="{{ $product->price }}">
            </div>
          </div>
        </div>
        
      </div>
      <!-- /.box-body -->

      <div class="box-footer">
        <button type="reset" class="btn btn-danger pull-left">Reset</button>
        <button type="submit" class="btn btn-primary pull-right"><i class="fa fa-edit"></i> Update</button>
      </div>
    </form>
  </div>
</div>  
@endsection

@section('scripts')
  <script type="text/javascript" src="{{ \URL::asset('js/summernote-bs4.min.js') }}"></script>
  @include('inventory.product.inc.script')
@endsection

