@extends('layouts.app')

@section('header')
<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Show Product</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="{{ \URL::to('/')}}">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="{{ \URL::to('product/view') }}">List Product</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Show Product</a>
                </li>
            </ul>
        </div>
    </div>
</div>

@endsection

@section('content')

<div class="card">
  <div class="card-block">

      <div class="box-body">
        <div class="row">
          <div class="col-sm-12">
              <label>Name: {{ $product->name }}</label><br>
            </div>
          </div>
        </div> 

        <div class="row">
          <div class="col-sm-12">
            <div class="form-group">
              <label>Description</label><br>
              <textarea id="summernote" class="form-control" name="description">{{ $product->description }}</textarea>
            </div>
          </div>
        </div> 

        <div class="row">
          <div class="col-sm-4">
            <div class="form-group">
              <label>Unit: {{ $product->unit }}</label><br>
            </div>
          </div>          
        </div>

        <div class="row">
          <div class="col-sm-4">
            <div class="form-group">
              <label>Price: {{ $product->price }}</label><br>
            </div>
          </div>
        </div>
        
      </div>
  </div>
</div>  
@endsection

@section('scripts')
  <script type="text/javascript" src="{{ \URL::asset('js/summernote-bs4.min.js') }}"></script>
  @include('inventory.product.inc.script')
@endsection

