@extends('layouts.app')

@section('header')
<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Product Tracking</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="{{ \URL::to('/')}}">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="{{ \URL::to('product/view') }}">List Product</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Product Tracking</a>
                </li>
            </ul>
        </div>
    </div>
</div>

@endsection

@section('content')

<div class="card">
  <div class="card-block">

      <div class="box-body">
        <div class="row">
          <div class="col-sm-12">
              <label>Name: {{ $product->name }}</label><br>
            </div>
          </div>
        </div> 

        <div class="row">
          <div class="col-sm-12">
            <div class="form-group">
              <label>Description</label><br>
              <textarea id="summernote" class="form-control" name="description">{!! $product->description !!}</textarea>
            </div>
          </div>
        </div> 
        
      </div>
  </div>


<div class="card">
  <div class="card-block">
      <div class="box-body">
        <div class="row">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Quotation</th>
                        <th>Customer</th>
                        <th>Quantity</th>
                        <th>Total Price</th>
                    </tr>
                </thead>
                <tbody class="item_container">
                    @foreach($products as $list)
                    <tr>                        
                        <td>
                            <p>{{ $list->quotation_number }}</p>
                        </td>
                        <td>
                            <p>{{ $list->customer_name  }}</p>
                        </td>
                        <td>
                            <p>{{ $list->quantity }}</p>
                        </td>
                        <td>
                            <p>{{ $list->total  }}</p>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>  
</div>      
      </div>
  </div>
</div>  
@endsection