@foreach($comments as $comment)
    <div class="display-comment @if($comment->parent_id != null) indented-comment @endif">

        <strong>{{ $comment->user->firstname." ".$comment->user->lastname }}</strong>
        <p>{{ $comment->body }}</p>
        <a href="" id="reply"></a>
        <form method="post" action="{{ \URL::to('comments/store') }}">
            {{ csrf_field() }}
            <div class="form-group">
                <input type="text" name="body" class="form-control" />
                <input type="hidden" name="quotation_id" value="{{ $quotation_id }}" />
                <input type="hidden" name="parent_id" value="{{ $comment->id }}" />
            </div>
            <div class="form-group">
                <input type="submit" class="btn btn-warning" value="Reply" />
            </div>
        </form>
        @include('inventory.quotation.commentsDisplay', ['comments' => $comment->replies])
    </div>
@endforeach