@extends('layouts.app')

@section('header')
<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Edit Quotation</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="{{ \URL::to('/')}}">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="{{ \URL::to('quotation/view') }}">List Quotation</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Edit Quotation</a>
                </li>
            </ul>
        </div>
    </div>
</div>

@endsection

@section('content')

<div class="card">
    <div class="card-block">
        <form method="post" action="{{ \URL::to('quotation/updateStatus') }}" data-parsley-validate="">
            {{ csrf_field() }}
            <input type="hidden" name="quotation_id" value="{{ $quotation->id }}">

            <div class="form-group">
                <label for="customer_id">Status</label>
                <select class="form-control" name="status" required>                    
                    @foreach($statusArr as $status)
                        <option value="{{ $status }}" {{ $status == $quotation->status ? 'selected="selected"' : '' }}>{{ $status }}</option>

                    @endforeach
                </select>
            </div>

            <div class="row">
                <label class="col-xl-4 col-md-4"></label>
                <div class="col-sm-10">
                    <button type="submit" class="btn btn-primary m-b-0">Update Status</button>
                </div>
            </div>           
        </form>
    </div>
</div>
        
<div class="card">
    <div class="card-block">
        <form id="paymentForm" method="post" action="{{ \URL::to('quotation/update') }}" data-parsley-validate="">

            {{ csrf_field() }}

            @if ($errors->any())
                <div class="alert alert-danger mt-3">
                    <strong>Oops!</strong> Please fix the following errors:<br>
                    <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                    </ul>
                </div>
            @endif
            <input type="hidden" name="quotation_id" value="{{ $quotation->id }}">

            <div class="row">
                <div class="col-xl-6 col-md-6">
                    
                    <div class="form-group">
                        <label for="customer_id">Customer</label>
                        <select class="form-control" id="customer_id" name="customer_id" required>
                            <option value="">-- Select Customer --</option>
                            <!-- Add options for customers here -->
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="requested_by">Requested By</label>
                        <input type="text" class="form-control" id="requested_by" name="requested_by" required   value="{{ $quotation->requested_by }}">
                    </div>
                </div>

                <div class="col-xl-6 col-md-6">
                    <div class="form-group">
                        <label>Date</label>
                        <input type="text" class="form-control" name="quotation_date" value="{{ date('d-m-Y') }}" readonly   value="{{ $quotation->quotation_date }}">
                    </div>

                    <div class="form-group">
                        <label>Quote Ref.</label>
                        <input type="text" class="form-control" name="quotation_ref" required autocomplete="off" value="{{ $quotation->quotation_ref }}">
                    </div>

                    <div class="form-group">
                        <label>Enquiry ref.</label>
                        <input type="text" class="form-control" name="enquiry_ref" required autocomplete="off"   value="{{ $quotation->enquiry_ref }}">
                    </div>
                </div>
            </div>

            <hr>

            <div class="row">
                <div class="col-xl-12 col-md-12">
                    <div class="box box-default">
                        <div class="box-body">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Product Name</th>
                                        <th>Quantity</th>
                                        <th>Unit</th>
                                        <th>Price</th>
                                        <th>Total</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody class="item_container">
                                    @foreach($quotationList as $list)
                                    <tr>
                                        <td>
                                            <input type="hidden" name="item_id[]" value="{{ $list->product_id }}">
                                            @php
                                                if (empty($list->catalogue))
                                                    $itemName = $list->name;
                                                else
                                                    $itemName = $list->name . " (" . $list->catalogue . ")";
                                            @endphp
                                            <input type="text" style="min-width: 250px" class="form-control search_item_name" placeholder="Type here ..." name="item_name[]" autocomplete="off" value="{{ $itemName }}">
                                            <span class="help-block search_item_name_empty" style="display: none;">No Results Found ...</span>
                                        </td>
                                        <td width="75px">
                                            <input type="number" class="form-control change_item_quantity" name="item_quantity[]" min="1" value="{{ $list->quantity }}">
                                        </td>
                                        <td width="100px">
                                            <input type="text" class="form-control" name="unit[]" readonly="" value="{{ $list->unit }}">
                                        </td>
                                        <td width="150px">
                                            <input type="number" class="form-control item_rate change_item_rate" name="price[]" step="0.1" value="{{ $list->price }}">
                                        </td>
                                        <td width="150px">
                                            <input type="text" class="form-control item_total" name="sub_total[]" readonly="" value="{{ $list->total  }}">
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-danger remove_tr">&times;</button>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="3">
                                            <button type="button" class="btn btn-primary add_item_product"><i class="fa fa-plus"></i> Add More</button>
                                        </td>
                                        <td></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-xl-4 col-md-4">
                    <div class="form-group">
                        <label for="notes">Notes</label>
                        <textarea class="form-control" style="height: 60px;" id="notes" name="notes"></textarea>
                    </div>
                </div>
                <div class="col-xl-4 col-md-4">
                    <!-- You can add more fields here if needed -->
                </div>
                <div class="col-xl-4 col-md-4">
                    <div class="form-group">
                        <label>Sub Total</label>
                        <input type="text" class="form-control final_total_bill" readonly name="final_total_bill" value="{{ $quotation->sub_total }}">
                    </div>
                    <div class="form-group">
                        <label>Tax Amount</label>
                        <input type="text" class="form-control item_tax_amount" readonly name="tax_percent" value="{{ $quotation->tax }}">
                    </div>
                    <div class="form-group">
                        <label>Grand Total</label>
                        <input type="text" class="form-control grand_total" readonly name="grand_total" value="{{ $quotation->total }}">
                    </div>
                </div>
            </div>

            <div class="row">
                <label class="col-xl-4 col-md-4"></label>
                <div class="col-sm-10">
                    <button type="submit" class="btn btn-primary m-b-0 form_submit">Update</button>
                </div>
            </div>

           
        </form>
    </div>
</div>

@endsection

@section('scripts')
    @include('inventory.quotation.inc.script')
    <script type="text/javascript">

        $('tbody').sortable();
        var customers_raw_data = '{!! $customers !!}';
        var customers_data = JSON.parse(customers_raw_data);

        $("#customer_id").select2({
            data: customers_data
        });  

        var customer_id = '{!! $quotation->customer_id !!}';

        $('#customer_id').val(customer_id);
        $('#customer_id').trigger('change'); 
    </script>
@endsection

