@extends('layouts.app')

@section('header')
<div class="card borderless-card">
  <div class="card-block primary-breadcrumb">
    <div class="breadcrumb-header">
      <h5>Purchase Report</h5>
    </div>
    <div class="page-header-breadcrumb">
      <ul class="breadcrumb-title">
        <li class="breadcrumb-item">
          <a href="{{ \URL::to('/')}}">
            <i class="fas fa-home"></i>
          </a>
        </li>
        <li class="breadcrumb-item"><a href="/report/generate"><i class="fa fa-line-chart"></i> Generate Report</a></li>
        <li class="breadcrumb-item"><a href="#">Purchase Report</a>
        </li>
      </ul>
    </div>
  </div>
</div>

@endsection


@section('content')

<style type="text/css">
  th,td {
      text-align: center;
  }
</style>



<div class="card">
  <div class="card-block">

    <form class="form-horizontal generate_report_inline" role="form" method="GET" action="{{ url('/report/view_report') }}">
      <div class="row">
      <div class="col-md-offset-3 col-md-2">
        <div class="form-group">
          <label>Report Type</label>
            <select class="form-control inline_report_type" name="report_type">
              <option selected="" disabled="" value="">- Select -</option>
              <option value="1" @if($data['report_type'] == 1) selected="" @endif>Purchase</option>
              <option value="2" @if($data['report_type'] == 2) selected="" @endif>Purchase List</option>
              <option value="3" @if($data['report_type'] == 3) selected="" @endif>Pharmacy</option>
              <option value="4" @if($data['report_type'] == 4) selected="" @endif>Pharmacy List</option>
              <option value="5" @if($data['report_type'] == 5) selected="" @endif>Pharmacy GST</option>
              <option value="7" @if($data['report_type'] == 7) selected="" @endif>Pharmacy GST Summary</option>
              <option value="6" @if($data['report_type'] == 6) selected="" @endif>Stock Movement</option>
            </select>
        </div>      
      </div>

      <div class="col-md-2">
        <div class="form-group">
          <label>From</label>
          <div class="input-group date">
            <div class="input-group-addon">
              <i class="fa fa-calendar"></i>
            </div>
            <input type="text" class="form-control pull-right inline_datepicker_from from" name="from" value="{{ \Carbon\Carbon::parse($data['from'])->format('m/d/Y') }}" autocomplete="off">
          </div>
        </div>
      </div>

      <div class="col-md-2">
        <div class="form-group">
          <label>To</label><br>
          <div class="input-group date">
            <div class="input-group-addon">
              <i class="fa fa-calendar"></i>
            </div>
            <input type="text" class="form-control pull-right inline_datepicker_to to" name="to" value="{{ \Carbon\Carbon::parse($data['to'])->format('m/d/Y') }}" autocomplete="off">
          </div>
        </div>
      </div>
      </div>
    </form>

    <section class="invoice">
    <!-- title row -->
    <div class="row">
      <div class="col-xs-12">
        <h2 class="page-header">
          <i class="fa fa-shopping-bag"></i> 

          @if($data['report_type'] == 1)
            Purchase
            <small class="pull-right">Dated: {{ \Carbon\Carbon::now()->format('jS M Y - h:i:s A') }}</small>
          @elseif($data['report_type'] == 2)
            Purchase List
            <small class="pull-right">Dated: {{ \Carbon\Carbon::now()->format('jS M Y - h:i:s A') }}</small>
          @elseif($data['report_type'] == 3)
            Pharmacy
            <small class="pull-right">Dated: {{ \Carbon\Carbon::now()->format('jS M Y - h:i:s A') }}</small>
          @elseif($data['report_type'] == 4)
            Pharmacy List
            <small class="pull-right">Dated: {{ \Carbon\Carbon::now()->format('jS M Y - h:i:s A') }}</small>
          @elseif($data['report_type'] == 5)
            Pharmacy GST
            <small class="pull-right">Dated: {{ \Carbon\Carbon::now()->format('jS M Y - h:i:s A') }}</small>
          @elseif($data['report_type'] == 6)
            Stock Movement
          @endif    
        </h2>
      </div>
      <!-- /.col -->
    </div>
    

    @if($data['report_type'] != 7)

    <!-- Table row -->
    <div class="row">
      <div class="table-responsive" style="width:99%;margin-left:5px">
        <table id="dt-purchase_report"  class="table table-striped">
          <thead>
          <tr>
            @foreach($params as $key => $param)
              <th>
                @if (strpos($param, '.') !== false)
                  {{  substr($param, strpos($param, ".") + 1)  }}
                @else
                  {{ $param }}
                @endif
              </th>
            @endforeach
          </tr>
          </thead>
          <tbody>
            @foreach($transaction as $atransaction)
              <tr>
                @foreach($atransaction as $key => $atransactionvalue)
                  <td>{{ $atransactionvalue }} </td>
                @endforeach
              </tr>
            @endforeach
          </tbody>
        </table>
      </div>
      <!-- /.col -->
    </div>


    @endif


    @if(!empty($gst_summary))

      <br>
      <h4>GST SUMMARY</h4>
      <h4></h4>

      <!-- Table row -->
      <div class="row">
        <div class="table-responsive" style="width:99%;margin-left:5px">
          <table id="dt-purchase_report"  class="table table-striped">
            <thead>
            <tr>
              <th>Rate</th>
              <th>Taxable Value</th>
              <th>CGST</th>
              <th>SGST</th>
              <th>Total Tax</th>
              <th>Invoice Value</th>
            </tr>
            </thead>
            <tbody>
                  @foreach($gst_summary as $kgst => $gstvalue)

                <tr>
                    <td> {{ $kgst }} </td>
                    <td> {{ $gstvalue['taxable_value'] }} </td>
                    <td> {{ $gstvalue['cgst'] }} </td>
                    <td> {{ $gstvalue['sgst'] }} </td>
                    <td> {{ $gstvalue['gst'] }} </td>
                    <td> {{ $gstvalue['invoice_value'] }} </td>

                </tr>
                  @endforeach
            </tbody>
          </table>
        </div>
      </div>
    @endif



    @if(!empty($cess))

      <br>
      <h4>TOTAL KERALA FLOOD CESS @1%</h4>
      <h4></h4>

      <!-- Table row -->
      <div class="row">
        <div class="table-responsive" style="width:99%;margin-left:5px">
          <table id="dt-purchase_report"  class="table table-striped">
            <thead>
            <tr>
              <th>12%</th>
              <th>18%</th>
              <th>28%</th>
            </tr>
            </thead>
            <tbody>
                <tr>
                  <td> {{ isset($cess["12%"]["cess"]) ? $cess["12%"]["cess"] : 0 }} </td>
                  <td> {{ isset($cess["18%"]["cess"]) ? $cess["18%"]["cess"] : 0 }} </td>
                  <td> {{ isset($cess["28%"]["cess"]) ? $cess["28%"]["cess"] : 0 }} </td>
                </tr>
            </tbody>
          </table>
        </div>
      </div>
    @endif





    <!-- /.row -->
  </section>
</div>
</div>
@endsection

@section('scripts')
@include('layouts.datatables_only_files')

<script type="text/javascript">

$(document).ready(function() {
    var dt = $('#dt-purchase_report').DataTable( {
        dom: 'Bfrtip',
        paging:   false,
        ordering: false,
        info:     false,
        buttons: [
              'excel', 'pdf', 'print'
          ]
    });
});


</script>
@endsection


