@extends('layouts.app')

@section('header')
<div class="card borderless-card">
  <div class="card-block primary-breadcrumb">
    <div class="breadcrumb-header">
      <h5>Generate Report</h5>
    </div>
    <div class="page-header-breadcrumb">
      <ul class="breadcrumb-title">
        <li class="breadcrumb-item">
          <a href="{{ \URL::to('/')}}">
            <i class="fas fa-home"></i>
          </a>
        </li>
        <li class="breadcrumb-item"><a href="#">Generate Report</a>
        </li>
      </ul>
    </div>
  </div>
</div>

@endsection

@section('content')

<div class="card">
  <div class="card-block">

    <form class="form-horizontal generate_report" role="form" method="GET" action="{{ url('/report/view_report') }}">

      {{ csrf_field() }}

      <div class="box-body">

        <div class="row">
          
          <div class="col-md-4">
            <div class="form-group">
              <label>Report Type</label>
              <select class="form-control" name="report_type">
                <option selected="" disabled="" value="">- Select -</option>
                <option value="1">Purchase</option>
                <option value="2">Purchase List</option>                
                <option value="3">Pharmacy</option>
                <option value="4">Pharmacy List</option>
                <option value="5">Pharmacy GST</option>
                <option value="7">Pharmacy GST Summary</option>
                <option value="6">Stock Movement</option>
              </select>
            </div>
          </div>

          <div class="col-md-4">
            <div class="form-group">
              <label>From</label>
              <div class="input-group date">
                <div class="input-group-addon">
                  <i class="fa fa-calendar"></i>
                </div>
                <input type="text" class="form-control pull-right from" name="from" autocomplete="off">
              </div>
            </div>
          </div>

          <div class="col-md-4">
            <div class="form-group">
              <label>To</label><br>
              <div class="input-group date">
                <div class="input-group-addon">
                  <i class="fa fa-calendar"></i>
                </div>
                <input type="text" class="form-control pull-right to" name="to" autocomplete="off">
              </div>
            </div>
          </div>

        </div>


      </div>
      <!-- /.box-body -->

      <div class="box-footer">
        <button type="reset" class="btn btn-danger pull-left">Reset</button>
        <button type="submit" name="submitName" class="btn btn-primary pull-right"><i class="fa fa-line-chart"></i> Generate </button>
      </div>
    </form>
  </div>
</div>
@endsection
