@extends('layouts.app')

@section('header')
<div class="card borderless-card">
  <div class="card-block primary-breadcrumb">
    <div class="breadcrumb-header">
      <h5>Purchase Report</h5>
    </div>
    <div class="page-header-breadcrumb">
      <ul class="breadcrumb-title">
        <li class="breadcrumb-item">
          <a href="{{ \URL::to('/')}}">
            <i class="fas fa-home"></i>
          </a>
        </li>
        <li class="breadcrumb-item"><a href="/report/generate"><i class="fa fa-line-chart"></i> Generate Report</a></li>
        <li class="breadcrumb-item"><a href="#">Purchase Report</a>
        </li>
      </ul>
    </div>
  </div>
</div>

@endsection


@section('content')

<style type="text/css">
  th,td {
      text-align: center;
  }
</style>



<div class="card">
  <div class="card-block">

    <form class="form-horizontal generate_report_inline" role="form" method="GET" action="{{ url('/report/view_report') }}">
      <div class="row">
      <div class="col-md-offset-3 col-md-2">
        <div class="form-group">
          <label>Report Type</label>
            <select class="form-control inline_report_type" name="report_type">
              <option selected="" disabled="" value="">- Select -</option>
              <option value="1" @if($data['report_type'] == 1) selected="" @endif>Purchase</option>
              <option value="2" @if($data['report_type'] == 2) selected="" @endif>Sales</option>
              {{-- <option value="3"  @if($data['report_type'] == 3) selected="" @endif>Purchase Stock</option> --}}
            </select>
        </div>      
      </div>

      <div class="col-md-2">
        <div class="form-group">
          <label>From</label>
          <div class="input-group date">
            <div class="input-group-addon">
              <i class="fa fa-calendar"></i>
            </div>
            <input type="text" class="form-control pull-right inline_datepicker_from from" name="from" value="{{ \Carbon\Carbon::parse($data['from'])->format('m/d/Y') }}" autocomplete="off">
          </div>
        </div>
      </div>

      <div class="col-md-2">
        <div class="form-group">
          <label>To</label><br>
          <div class="input-group date">
            <div class="input-group-addon">
              <i class="fa fa-calendar"></i>
            </div>
            <input type="text" class="form-control pull-right inline_datepicker_to to" name="to" value="{{ \Carbon\Carbon::parse($data['to'])->format('m/d/Y') }}" autocomplete="off">
          </div>
        </div>
      </div>
      </div>
    </form>

    <section class="invoice">
    <!-- title row -->
    <div class="row">
      <div class="col-xs-12">
        <h2 class="page-header">
          <i class="fa fa-shopping-bag"></i> Purchase Report
          <small class="pull-right">Dated: {{ \Carbon\Carbon::now()->format('jS M Y - h:i:s A') }}</small>
        </h2>
      </div>
      <!-- /.col -->
    </div>
    

    <!-- Table row -->
    <div class="row">
      <div class="table-responsive" style="width:99%;margin-left:5px">
        <table id="dt-purchase_report"  class="table table-striped">
          <thead>
          <tr>
            <th>Transaction ID</th>
            <th>Date</th>
            <th>Purchase ID</th>
            <th>Supplier</th>
            <th>Grand total</th>
            <th>Paid</th>
            <th>Balance</th>
            <th>Due</th>
          </tr>
          </thead>
          <tbody>
            @foreach($transaction as $key => $value)
              <tr>
                <td>{{ $value->id }}</td>
                <td>{{ \Carbon\Carbon::parse($value->created_at)->format('jS M Y') }}</td>
                <td>{{ $value->purchase_id }}</td>
                <td>{{ isset($value->supplier->supplier_name) ? $value->supplier->supplier_name : '' }}</td>
                <td> <i class="fa fa-inr"></i> {{ $value->subtotal }}</td>
                <td> <i class="fa fa-inr"></i> {{ $value->payment }}</td>
                <td> <i class="fa fa-inr"></i> {{ $value->balance }}</td>
                <td> <i class="fa fa-inr"></i> {{ $value->due }}</td>
              </tr>
            @endforeach

              <tr>
                <td>Report Date :</td>
                <td>{{ $data['from']->format('jS M Y') }} - {{ $data['to']->format('jS M Y') }}</td>
                <td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
                <td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
              </tr>
              <tr>
                <td>Total Purchase:</td>
                <td> <i class="fa fa-inr"></i> {{ $total['purchase'] }}</td>
                <td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
                <td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
              </tr>
              <tr>
                <td>Paid Purchase:</td>
                <td> <i class="fa fa-inr"></i> {{ $total['payment'] }}</td>
                <td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
                <td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
              </tr>
              <tr>
                <td>Balance Purchase:</td>
                <td> <i class="fa fa-inr"></i> {{ $total['balance'] }}</td>
                <td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
                <td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
              </tr>
              <tr>
                <td>Due Purchase:</td>
                <td> <i class="fa fa-inr"></i> {{ $total['due'] }}</td>
                <td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
                <td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
              </tr>
          </tbody>
        </table>
      </div>
      <!-- /.col -->
    </div>
    <!-- /.row -->
  </section>
</div>
</div>
@endsection

@section('scripts')
@include('layouts.datatables_only_files')

<script type="text/javascript">

$(document).ready(function() {
    var dt = $('#dt-purchase_report').DataTable( {
        dom: 'Bfrtip',
        paging:   false,
        ordering: false,
        info:     false,
        buttons: [
              'excel', 'pdf', 'print'
          ]
    });
});


</script>
@endsection


