@extends('layouts.app')


@section('header')

<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Add Pharmacy</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="{{ \URL::to('/')}}">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="{{ \URL::to('sales/view') }}">List Pharmacy</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Add Pharmacy</a>
                </li>
            </ul>
        </div>
    </div>    
</div>

@endsection

@section('content')

<!-- Basic Form Inputs card start -->
<div class="card">
  <div class="card-header">
    <label></label>
  </div>
  <div class="card-block">
    <form class="form-horizontal create_sales" role="form" method="POST" action="{{ url('/sales/store') }}">

      {{ csrf_field() }}

      <input type="hidden" class="hptype" value="outpatient">
      <input type="hidden" name="branch_id" value="{{ $branch_id }}">
      

      <div class="box-body">

        <div class="box box-default">
          <div class="box-body">
            <div class="row">
              <div class="col-sm-4">
                <label>Patient Type</label>
                <select class="form-control ptype" name="ptype">
                  <option value="outpatient" selected>Out patient</option>
                  <option value="inpatient">In patient</option>
                </select>
              </div>
            </div>
            <hr>
            <div class="row">
              <div class="col-sm-6">
                <div class="form-group">
                  <label class="search_customer_label">Patient Name</label>
                  <input type="text" class="form-control search_customer_name" placeholder="Type here ..." name="customer_name" required="">
                  <span class="help-block search_customer_name_empty" style="display: none;">No Results Found ...</span>

                  <span class="help-block search_sales_purchase_category_name_empty" style="display: none;">No Results Found ...</span>
                  <input type="hidden" class="search_customer_id" name="customer_id">
                  <input type="hidden" class="search_admission_id" name="admission_id">
                </div>
              </div>
              <div class="col-sm-3">
                <div class="form-group">
                  <label>Address</label><br>
                  <input type="text" class="form-control search_customer_address" name="customer_address">
                </div>
              </div>

              <div class="col-sm-3">
                <div class="form-group">
                  <label>Contact</label><br>
                  <input type="text" class="form-control search_customer_contact1" name="customer_contact1">
                </div>
              </div>

              <div class="col-sm-2">
                <div class="form-group">
                  <label>Opening Balance</label><br>
                  <input type="text" name="opening_balance" class="form-control opening_balance" readonly="">
                </div>
              </div>

              <div class="col-sm-2">
                <div class="form-group">
                  <label>Opening Due</label><br>
                  <input type="text" name="opening_due" class="form-control opening_due" readonly="">
                </div>
              </div>

            </div>
          </div>
        </div>

        <div class="box box-default">
          <div class="box-body">
            <table class="table table-striped">
              <thead>
                <tr>
                  <th>Stock Catagory</th>
                  <th>Physical Quantity</th>
                  <th>Purchase Cost</th>
                  <th>GST</th>
                  <th>Selling Cost</th>
                  <th>No.of.Units</th>
                  <th>Total</th>
                </tr>
              </thead>
              <tbody class="sales_container">
                <tr>
                  <td width="100px">
                    <input type="text" class="form-control search_sales_purchase_category_name" placeholder="Type here ..." name="category_name[]" autocomplete="off">
                    <span class="help-block search_sales_purchase_category_name_empty glyphicon" style="display: none;"> No Results Found </span>
                    <input type="hidden" class="search_category_id" name="category_id[]">
                  </td>
                  <td width="350px">
                    <select class="form-control stock_id" name="stock_id[]">
                      <option selected="" disabled="" value="">select</option>
                    </select>
                    <span class="search_stock_quantity"></span>
                  </td>
                  <td width="100px">
                    <input type="text" class="form-control search_purchase_cost" name="purchase_cost[]" readonly="">
                  </td>
                  <td width="100px">
                    <input type="text" class="form-control search_purchase_gst" name="purchase_gst[]" readonly="">
                  </td>
                  <td width="100px">
                    <input type="text" class="form-control search_selling_cost" name="selling_cost[]" readonly="">
                  </td>

                  <td width="50px">
                    <input type="hidden" class="search_stock_quantity" name="opening_stock[]">
                    <input type="hidden" class="closing_stock" name="closing_stock[]">

                    <input type="number" class="form-control change_sales_quantity" name="sales_quantity[]" min="1">
                    <small class="help-block max_stock" style="display: none;">Insufficient Stock</small>
                  </td>

                  <td width="150px">
                    <input type="text" class="form-control stock_total" name="sub_total[]"  readonly="">
                  </td>

                  <td><button type="button" class="btn btn-danger remove_tr">&times;</button></td>
                </tr>
              </tbody>
              <tfoot>
                <tr>
                  <td colspan="3">
                    <button type="button" class="btn btn-primary add_sales_product"><i class="fa fa-plus"></i> Add More</button>
                  </td>
                  <td></td>
                </tr>
              </tfoot>
            </table>

            <div class="row">
              <div class="col-md-offset-8 col-md-4">
                <div class="form-group">
                  <label>Pharmacy total</label><br>
                  <input type="text" class="form-control sales_total" readonly="" name="sales_total">
                </div>
              </div>
              {{-- <div class="col-md-offset-8 col-md-4">
                <div class="form-group">
                  <label>Kerala Flood cess @1%</label><br>
                  <input type="text" class="form-control kerala_flood_cess" readonly="" name="cess">
                </div>
              </div> --}}
            </div>

            <input type="hidden" class="form-control sales_discount_percent" name="discount_percent" value="0">
            <input type="hidden" class="form-control sales_discount_amount" name="discount_amount" value="0">

            <!-- <div class="row">
              <div class="col-md-offset-4 col-md-4">
                <div class="form-group">
                  <label>Discount ( % )</label><br>
                  <input type="number" class="form-control sales_discount_percent" name="discount_percent" step="0.01" min="0" max="100" value="0">
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label>Discount ( Amount )</label><br>
                  <input type="text" class="form-control sales_discount_amount" name="discount_amount" step="0.01" min="0" value="0">
                </div>
              </div>
            </div>

             <div class="row">

              <div class="col-md-4">
                <div class="form-group">
                  <label>GST Description</label><br>
                  <input type="text" class="form-control" name="tax_description">
                </div>
              </div>

              <div class="col-md-4">
                <div class="form-group">
                  <label>GST ( % )</label><br>
                  <input type="number" class="form-control sales_tax_percent" name="tax_percent"  step="0.01" min="0" max="100" value="0">
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label>GST ( Amount )</label><br>
                  <input type="text" class="form-control sales_tax_amount" name="tax_amount"   step="0.01" min="0" value="0">
                </div>
              </div>
            </div> -->

          </div>
        </div>

        <div class="box box-default">
          <div class="box-body">
            <div class="row">

              <!-- <div class="col-sm-2">
                <div class="form-group">
                  <label>Pharmacy Description</label><br>
                  <textarea class="form-control" style="height: 35px;" name="sales_description"></textarea>
                </div>
              </div> -->

              <div class="col-sm-2">
                <div class="form-group">
                  <label>Grand Total</label><br>
                  <input type="text" class="form-control grand_total" name="grand_total" readonly="">
                </div>
              </div>

              <div class="col-sm-2">
                <div class="form-group">
                  <label>Payment</label><br>
                  <input type="text" class="form-control sales_payment" name="payment">
                </div>
              </div>

              <div class="col-sm-2">
                <div class="form-group">
                  <label>Closing Balance</label><br>
                  <input type="text" class="form-control closing_balance" name="closing_balance" readonly="">
                </div>
              </div>

              <div class="col-sm-2">
                <div class="form-group">
                  <label>Closing Due</label><br>
                  <input type="text" class="form-control closing_due" name="closing_due" readonly="">
                </div>
              </div>

              <div class="col-sm-2">
                <div class="form-group">
                  <label>Mode</label>
                  <select class="form-control" name="mode">
                    @foreach($payment as $pay)
                      <option value="{{ $pay['id'] }}">{{ $pay['text'] }}</option>
                    @endforeach
                  </select>
                </div>
              </div>

            </div>
          </div>
        </div>

      </div>
      <!-- /.box-body -->

      <div class="box-footer">
        <button type="reset" class="btn btn-danger pull-left">Reset</button>
        <input type="submit" name="submit_button" value="Add"  class="btn btn-primary pull-right form_submit"/> 
        <input type="submit" name="submit_button" value="Add & Print" class="btn btn-primary pull-right form_submit" />
      </div>
    </form>
  </div>
  <!-- /.box-body -->
</div>
@endsection

@section('scripts')
  @include('inventory.sales.inc.script')
@endsection

