@extends('layouts.app')


@section('header')
<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Edit Pharmacy</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="{{ \URL::to('/')}}">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="{{ \URL::to('sales/view') }}">List Pharmacy</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Edit Pharmacy</a>
                </li>
            </ul>
        </div>
    </div>
</div>

@endsection

@section('content')

<div class="card">
  <div class="card-block">
    <form class="form-horizontal create_sales" role="form" method="POST" action="{{ url('/sales/update/'.$sales_details->sales_id) }}">

        {{ csrf_field() }}
        <input type="hidden" name="branch_id" value="{{ $branch_id }}">

        <div class="box box-default">
          <div class="box-body">
            <div class="row">
              <div class="col-sm-4">
                <label>Patient Type</label>
                <select class="form-control ptype" name="ptype">
                  @if(!empty($sales_details->admission_id))
                    <option value="inpatient" selected>In patient</option>
                    <option value="outpatient">Out patient</option>
                  @else
                    <option value="outpatient" selected>Out patient</option>
                    <option value="inpatient">In patient</option>
                  @endif
                </select>
              </div>
            </div>
            <hr>
            <div class="row">
              <div class="col-sm-6">
                <div class="form-group">
                  <label class="search_customer_label">Admission Code/Patient Name</label>
                  <input type="text" class="form-control search_customer_name" placeholder="Type here ..." name="customer_name" required="" value="{{ $sales_details->customer_name }}">
                  <span class="help-block search_customer_name_empty" style="display: none;">No Results Found ...</span>

                  <span class="help-block search_sales_purchase_category_name_empty" style="display: none;">No Results Found ...</span>
                  <input type="hidden" class="search_customer_id" name="customer_id" value="{{ $sales_details->customer_id }}">
                  <input type="hidden" class="search_admission_id" name="admission_id" value="{{ $sales_details->admission_id }}">
                </div>
              </div>
              <div class="col-sm-3">
                <div class="form-group">
                  <label>Address</label><br>
                  <input type="text" class="form-control search_customer_address" name="customer_address" value="{{ $sales_details->customer_address }}">
                </div>
              </div>

              <div class="col-sm-3">
                <div class="form-group">
                  <label>Contact</label><br>
                  <input type="text" class="form-control search_customer_contact1" name="customer_contact1" value="{{ $sales_details->customer_contact1 }}">
                </div>
              </div>

              <div class="col-sm-2">
                <div class="form-group">
                  <label>Opening Balance</label><br>
                  <input type="text" name="opening_balance" class="form-control opening_balance" readonly=""  value="{{ $sales_details->opening_balance }}">
                </div>
              </div>

              <div class="col-sm-2">
                <div class="form-group">
                  <label>Opening Due</label><br>
                  <input type="text" name="opening_due" class="form-control opening_due" readonly=""  value="{{ $sales_details->opening_due }}">
                </div>
              </div>

            </div>
          </div>
        </div>

        <div class="box box-default">
          <div class="box-body">
            <table class="table table-striped">
              <thead>
                <tr>
                  <th>Stock Catagory</th>
                  <th>Physical Quantity</th>
                  <th>Purchase Cost</th>
                  <th>GST</th>
                  <th>Selling Cost</th>
                  <th>No.of.Units</th>
                  <th>Total</th>
                </tr>
              </thead>
              <tbody class="sales_container">
                @foreach($sales_list as $list)
                  <tr>
                    <td width="100px">
                      <input type="text" class="form-control edit_search_sales_purchase_category_name" placeholder="Type here ..." name="category_name[]" autocomplete="off" value="{{ $list->category_name }}">
                      <span class="help-block search_sales_purchase_category_name_empty glyphicon" style="display: none;"> No Results Found </span>
                      <input type="hidden" class="search_category_id" name="category_id[]" value="{{ $list->category_id }}">
                    </td>
                    <td width="350px">
                      <select class="form-control stock_id" name="stock_id[]">
                        <option selected="" value="{{ $list->stock->stock_id }}">{{ $list->stock->stock_name }}</option>
                      </select>
                      <span class="search_stock_quantity"></span>
                    </td>
                    <td width="100px">
                      <input type="text" class="form-control search_purchase_cost" name="purchase_cost[]" value="{{ $list->purchase_cost }}" readonly="">
                    </td>
                    <td width="100px">
                      <input type="text" class="form-control search_purchase_gst" name="purchase_gst[]" value="{{ $list->gst }}" readonly="">
                    </td>
                    <td width="100px">
                      <input type="text" class="form-control search_selling_cost" name="selling_cost[]" value="{{ $list->selling_cost }}" readonly="">
                    </td>

                    <td width="50px">
                      <input type="hidden" class="search_stock_quantity" name="opening_stock[]" value="{{ ($branch_id == 1) ? $list->stock->b1_stock_quantity : $list->stock->b2_stock_quantity }}">
                      <input type="hidden" class="closing_stock" name="closing_stock[]" value="{{ ($branch_id == 1) ? $list->stock->b1_stock_quantity : $list->stock->b2_stock_quantity }}">

                      <input type="number" class="form-control change_sales_quantity" name="sales_quantity[]" min="1" max="{{ ($branch_id == 1) ? ($list->sales_quantity + $list->stock->b1_stock_quantity) : ($list->sales_quantity + $list->stock->b2_stock_quantity) }}" value="{{ $list->sales_quantity }}">
                      <small class="help-block max_stock" style="display: none;">Insufficient Stock</small>
                    </td>

                    <td width="100px">
                      <input type="text" class="form-control stock_total" name="sub_total[]"  readonly="" value="{{ $list->sub_total }}">
                    </td>

                    <td><button type="button" class="btn btn-danger remove_tr">&times;</button></td>
                  </tr>
                @endforeach
              </tbody>
              <tfoot>
                <tr>
                  <td colspan="3">
                    <button type="button" class="btn btn-primary add_sales_product"><i class="fa fa-plus"></i> Add More</button>
                  </td>
                  <td></td>
                </tr>
              </tfoot>
            </table>
          </div>

          <div class="row">
              <div class="col-md-offset-8 col-md-4">
                <div class="form-group">
                  <label>Pharmacy total</label><br>
                  <input type="text" class="form-control sales_total" readonly="" name="sales_total" value="{{ $sales_details->sales_total }}">
                </div>
              </div>
              {{-- <div class="col-md-offset-8 col-md-4">
                <div class="form-group">
                  <label>Kerala Flood cess @1%</label><br>
                  <input type="text" class="form-control kerala_flood_cess" readonly="" name="cess"
                  value="{{ $sales_details->cess }}">
                </div>
              </div> --}}
            </div>

            <input type="hidden" class="form-control sales_discount_percent" name="discount_percent" value="0">
            <input type="hidden" class="form-control sales_discount_amount" name="discount_amount" value="0">

            <!-- <div class="row">
              <div class="col-md-offset-4 col-md-4">
                <div class="form-group">
                  <label>Discount ( % )</label><br>
                  <input type="number" class="form-control sales_discount_percent" name="discount_percent" step="0.01" min="0" max="100" value="0" value="{{ $sales_details->discount_percent }}">
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label>Discount ( Amount )</label><br>
                  <input type="text" class="form-control sales_discount_amount" name="discount_amount" step="0.01" min="0" value="0" value="{{ $sales_details->discount_amount }}">
                </div>
              </div>
            </div>

            <div class="row">

              <div class="col-md-4">
                <div class="form-group">
                  <label>GST Description</label><br>
                  <input type="text" class="form-control" name="tax_description">
                </div>
              </div>

              <div class="col-md-4">
                <div class="form-group">
                  <label>GST ( % )</label><br>
                  <input type="number" class="form-control sales_tax_percent" name="tax_percent"  step="0.01" min="0" max="100" value="0">
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label>GST ( Amount )</label><br>
                  <input type="text" class="form-control sales_tax_amount" name="tax_amount"   step="0.01" min="0" value="0">
                </div>
              </div>
            </div> -->

        <div class="box box-default">
          <div class="box-body">
            <div class="row">

              <!-- <div class="col-sm-2">
                <div class="form-group">
                  <label>Pharmacy Description</label><br>
                  <textarea class="form-control" style="height: 35px;" name="sales_description"></textarea>
                </div>
              </div> -->

              <div class="col-sm-2">
                <div class="form-group">
                  <label>Grand Total</label><br>
                  <input type="text" class="form-control grand_total" name="grand_total" readonly=""  value="{{ $sales_details->grand_total }}">
                </div>
              </div>

              <div class="col-sm-2">
                <div class="form-group">
                  <label>Payment</label><br>
                  <input type="text" class="form-control sales_payment" name="payment" value="{{ $sales_details->payment }}">
                </div>
              </div>

              <div class="col-sm-2">
                <div class="form-group">
                  <label>Closing Balance</label><br>
                  <input type="text" class="form-control closing_balance" name="closing_balance" readonly="" value="{{ $sales_details->closing_balance }}">
                </div>
              </div>

              <div class="col-sm-2">
                <div class="form-group">
                  <label>Closing Due</label><br>
                  <input type="text" class="form-control closing_due" name="closing_due" readonly=""  value="{{ $sales_details->closing_due }}">
                </div>
              </div>

              <div class="col-sm-2">
                <div class="form-group">
                  <label>Mode</label>
                  <select class="form-control" name="mode">                      
                      @foreach($payment as $pay)
                        <option value="{{ $pay['id'] }}" {{ ($sales_details->mode == $pay['id']) ? 'selected' : ''  }}>{{ $pay['text'] }}</option>
                      @endforeach
                    </select>
                </div>
              </div>

            </div>
          </div>
        </div>


            </div>
            <!-- /.box-body -->

            <div class="box-footer">
              <button type="reset" class="btn btn-danger pull-left">Reset</button>
              <button type="submit" class="btn btn-primary pull-right"><i class="fa fa-edit"></i> Update</button>
            </div>
    </form>
  </div>
</div>

@endsection

@section('scripts')
  @include('inventory.sales.inc.script')
@endsection
