<script type="text/javascript">


    $(document).on('change', '.ptype', function() {

        if($(this).val() == 'outpatient') {
            $('.search_customer_label').text('Patient Name');
            $('.hptype').val("outpatient");
        } else {
            $('.search_customer_label').text('Admission Code/Patient Name');
            $('.hptype').val("inpatient");
        }

        $('.search_customer_id').val("");
        $('.search_admission_id').val("");
        $('.search_customer_name').val("");
        $('.search_customer_address').val("");
        $('.search_customer_contact1').val("");
    });

	/* Sales */

    $(".search_customer_name").autocomplete({
        //source: "/search/patient_name?type="+ $('.hptype').val(),
        source: function(request, response) {
            $.ajax({
                url: "/search/patient_name",
                dataType: "json",
                data: {
                    term : request.term,
                    type : $('.hptype').val()
                },
                success: function(data) {
                    response(data);
                },
                response: function(event, ui) {
                    if (ui.content.length === 0) {

                        $(this).parent().addClass('has-error');
                        $(this).next().removeClass('glyphicon-ok').addClass('glyphicon-remove');
                        $(".search_customer_name_empty").show();
                        $('.form_submit').hide();

                    } else {
                        $(".search_customer_name_empty").hide();
                        $('.form_submit').show();
                    }
                }
            });
        },
        minLength: 1,
        select: function(event, ui) {
            $('.search_customer_id').val(ui.item.id);
            $('.search_admission_id').val(ui.item.admission_id);
            $('.search_customer_name').val(ui.item.value);
            $('.search_customer_address').val(ui.item.address);
            $('.search_customer_contact1').val(ui.item.mobile);

            $('.opening_balance').val(ui.item.ph_balance);
            $('.opening_due').val(ui.item.ph_due);

            var grand = parseFloat(ui.item.due - ui.item.balance).toFixed(2);
            $('.grand_total').val( grand );
        }
    });

    $( ".search_customer_name" ).on('keyup',function(){
        $(".search_customer_name_empty").hide();
    });

    $(document).on('click', '.add_sales_product', function() {

        $('.sales_container').append('<tr><td width="100px"><input type="text" class="form-control search_sales_purchase_category_name" placeholder="Type here ..." name="category_name[]" autocomplete="off"><span class="help-block search_sales_purchase_category_name_empty glyphicon" style="display: none;"> No Results Found </span><input type="hidden" class="search_category_id" name="category_id[]"></td><td width="350px"><select class="form-control stock_id" name="stock_id[]"><option selected="" disabled="" value="">select</option></select><span class="search_stock_quantity"></span></td><td width="100px"><input type="text" class="form-control search_purchase_cost" name="purchase_cost[]" readonly=""></td><td width="100px"><input type="text" class="form-control search_purchase_gst" name="purchase_gst[]" readonly=""></td><td width="100px"><input type="text" class="form-control search_selling_cost" name="selling_cost[]" readonly=""></td><td width="50px"><input type="hidden" class="search_stock_quantity" name="opening_stock[]"><input type="hidden" name="closing_stock[]" class="closing_stock"><input type="number" class="form-control change_sales_quantity" name="sales_quantity[]" min="1"><small class="help-block max_stock" style="display: none;">Insufficient Stock</small></td><td width="100px"><input type="text" class="form-control stock_total" name="sub_total[]" readonly=""></td><td><button type="button" class="btn btn-danger remove_tr">&times;</button></td></tr>');

        $( ".search_sales_purchase_category_name" ).autocomplete({
          source: "/search/sales_purchase_category_name",
          minLength: 1,
          response: function(event, ui) {
                if (ui.content.length === 0) {

                    $(this).parent().addClass('has-error');
                    $(this).next().removeClass('glyphicon-ok').addClass('glyphicon-remove');
                    $(this).next().show();
                    $('.form_submit').hide();

                } else {
                    $(this).next().hide();
                    $('.form_submit').show();
                }
            },
          select: function(event, ui) {

            $(this).next().next().val(ui.item.id);
            var select = $(this).parent().next().children(':first-child');

            select.empty().append('<option selected="" disabled="" value="">- Select -</option>');

            $.each( ui.item.stocks , function( key, value ) {
                select.append('<option title="'+value.title+'" purchase_cost="'+value.purchase_cost+'" gst="'+value.gst+'" selling_cost="'+value.selling_cost+'" opening_stock="'+value.opening_stock+'" value='+key+'>'+value.dimention+'</option>');
            });

          }
        });

        calculate_sales();
    });



    $('.sales_discount_percent').on('keyup',function(){

        var discount_percent = parseFloat( $(this).val() || 0).toFixed(2); 
        var sub_total = parseFloat($('.sales_total').val()).toFixed(2);
        var tax = parseFloat($('.sales_tax_amount').val()).toFixed(2);
        var discount = parseFloat( (sub_total * discount_percent)/100 ).toFixed(2);

        $('.sales_discount_amount').val(discount || 0);

        calculate_sales();

    });

    $('.sales_discount_amount').on('keyup',function(){

        var discount = parseFloat($(this).val() || 0).toFixed(2); 
        var sub_total = parseFloat($('.sales_total').val() || 0).toFixed(2);
        var tax = parseFloat($('.sales_tax_amount').val() || 0).toFixed(2);
        var discount_percent = ((discount*100)/sub_total || 0).toFixed(2);

        $('.sales_discount_percent').val(discount_percent || 0);

        calculate_sales();

    });

    $('.sales_tax_percent').on('keyup',function(){

        var tax_percent = parseFloat($(this).val() || 0).toFixed(2); 
        var sub_total = parseFloat($('.sales_total').val() || 0).toFixed(2);
        var discount = parseFloat($('.sales_discount_amount').val() || 0).toFixed(2);

        var tax = parseFloat( (sub_total * tax_percent)/100 || 0 ).toFixed(2);

        $('.sales_tax_amount').val(tax || 0);

        calculate_sales();
    });

    $('.sales_tax_amount').on('keyup',function(){

        var tax = parseFloat($(this).val() || 0).toFixed(2); 
        var sub_total = parseFloat($('.sales_total').val() || 0).toFixed(2);
        var discount = parseFloat($('.sales_discount_amount').val() || 0).toFixed(2);

        var tax_percent = ((tax*100)/sub_total || 0).toFixed(2);

        $('.sales_tax_percent').val(tax_percent || 0);

        calculate_sales();

    });

    function calculate_sales() {
        
        var stock_sum = gst_sum = 0;

        var gst_array = $(".search_purchase_gst")
              .map(function(){return $(this).val();}).get();
        var sales_quantity_array = $(".change_sales_quantity")
              .map(function(){return $(this).val();}).get();
        var selling_cost_array = $(".search_selling_cost")
              .map(function(){return $(this).val();}).get();
        var stock_array = $(".stock_total")
              .map(function(){return $(this).val();}).get();

        for (var i = 0; i < stock_array.length; i++) {
            stock_sum += +stock_array[i];

            // if(gst_array[i] > 5) {
            //     var new_purchase_cess = 0;
            //     new_purchase_cess = selling_cost_array[i] / (1 + (gst_array[i]/100) );
            //     console.log(new_purchase_cess);
            //     gst_sum += +(new_purchase_cess * sales_quantity_array[i]); 
            //     console.log(gst_sum);
            // }
        }

        $('.sales_total').val(stock_sum);

        // if(gst_sum > 0) {
        //     gst_sum = parseFloat(gst_sum / 100).toFixed(2);
        // }

        // $('.kerala_flood_cess').val(gst_sum);

        var total    = parseFloat($('.sales_total').val()).toFixed(2);
        var discount = parseFloat( $('.sales_discount_amount').val() ).toFixed(2);

        //var grand_total = ( (parseFloat($('.opening_due').val()) + parseFloat($('.sales_total').val()) + parseFloat($('.kerala_flood_cess').val())) - parseFloat($('.opening_balance').val())).toFixed(2);

        var new_grand_total = ( ( parseFloat($('.opening_due').val()) + parseFloat($('.sales_total').val()) ) - parseFloat($('.opening_balance').val())).toFixed(2);

        //console.log(grand_total);
        //console.log(new_grand_total);

        // var tax      = parseFloat( $('.sales_tax_amount').val() ).toFixed(2);
        // var grand    = (parseFloat(total-discount) + parseFloat(tax)).toFixed(2);
        $('.grand_total').val( new_grand_total || '');

    }



    $(document).on('click', '.remove_tr', function(){
        $(this).closest('tr').remove();
        calculate_sales();
    });

    $(document).on('change','.stock_id',function(){

        $(this).parent().next().children(':first-child').val($(this).find(':selected').attr('purchase_cost'));

        $(this).parent().next().next().children(':first-child').val($(this).find(':selected').attr('gst'));

        $(this).parent().next().next().next().children(':first-child').val($(this).find(':selected').attr('selling_cost'));

        $(this).parent().next().next().next().next().find(':nth-child(1)').val($(this).find(':selected').attr('opening_stock'));

        $(this).parent().next().next().next().next().find(':nth-child(3)').attr('max',$(this).find(':selected').attr('opening_stock'));

        $(this).next().html('Available Stocks : '+$(this).find(':selected').attr('opening_stock'));

        calculate_sales();

    });

    $(document).on('keyup','.change_sales_quantity',function() {

        if(  parseInt( $(this).val() ) >  parseInt( $(this).attr('max') ) ){
            $(this).parent().addClass('has-error');
            $(this).next().removeClass('glyphicon-ok').addClass('glyphicon-remove');
            $('.form_submit,.add_sales_product').hide();
            $('.max_stock').show();
        }else{
            $(this).parent().removeClass('has-error');
            $('.form_submit,.add_sales_product').show();
            $('.max_stock').hide();
        }

        var quantity = parseFloat($(this).val()).toFixed(2);
        var cost = parseFloat( $(this).parent().prev().children(':first-child').val() ).toFixed(2);
        var total = parseFloat(quantity*cost || 0).toFixed(2);

        $(this).parent().next().children(':first-child').val(total);

        var opening = parseInt( $(this).prev().prev().val() );

        $(this).prev().val( parseInt(opening - quantity) );

        calculate_sales();
        
    });



    $(document).on('keyup','.search_selling_cost',function(){

        var quantity = parseFloat( $(this).parent().next().find(':nth-child(3)').val() ).toFixed(2);
        var cost = parseFloat( $(this).val() ).toFixed(2);
        var total = parseFloat(quantity*cost || 0).toFixed(2);

        $(this).parent().next().next().children(':first-child').val(total);

        calculate_sales();
        
    });    

    $('.sales_payment').on('keyup',function(){

        var payment =  parseFloat($(this).val()).toFixed(2);
        var grand_total =  parseFloat($('.grand_total').val()).toFixed(2);
        var opening_balance =  parseFloat($('.opening_balance').val()).toFixed(2);
        var opening_due =  parseFloat($('.opening_due').val()).toFixed(2);

        if( (grand_total - payment) > 0 ){
            $('.closing_due').val(grand_total - payment);
            $('.closing_balance').val(0);
        }
        else{
            $('.closing_due').val(0);
            $('.closing_balance').val( (payment - grand_total) || 0);
        } 
    });
</script>