@extends('layouts.app')

@section('header')
<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Pharmacy</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="{{ \URL::to('/')}}">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="{{ \URL::to('sales/view') }}">List Pharmacy</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Show Pharmacy</a>
                </li>
            </ul>
        </div>
    </div>
</div>

@endsection

@section('content')

@php
    
    $address = [];

    if($sales_details->branch_id == 1) 
        $address = \Config::get('formdata.address_m');
    else
        $address = \Config::get('formdata.address_p');

@endphp

<!-- Basic Form Inputs card start -->
<!-- Invoice card start -->
<div class="card" id="DivIdToPrint">    
    <div class="card-block">
        <div class="row invoice-contact">
            <div class="col-12 col-sm-12 col-md-12 col-lg-12">
                <img src="{{ \URL::asset('images/main_logo.png') }}" width="100" height="100" class="m-b-10" alt="">
            </div>
            <div class="col-6 col-sm-6 col-md-6 col-lg-6">
                <div class="invoice-box row">
                    {!! \FormHelper::getAddress($address) !!}
                </div>
            </div>
            <div class="col-6 col-sm-6 col-md-6 col-lg-6">
                <div class="invoice-box row">
                    <table class="table table-responsive invoice-table table-borderless">
                        <tbody>
                            <tr>
                                <td><b>GSTIN:</b>  {{ \Config::get('formdata.gst') }}</td>
                            </tr>
                            <tr>
                                <td><b>Pharmacy Information</b></td>
                            </tr>
                            <tr>
                                <td><b>Pharmacy Date:</b>  {{ date('d-m-Y', strtotime($sales_details->created_at)) }}</td>
                            </tr>
                            <tr>
                                <td><b>Pharmacy Id:</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{ $sales_details->code }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            {{-- <div class="col-4 col-sm-4 col-md-4 col-lg-4">
                <div class="invoice-box row">
                    <table class="table table-responsive invoice-table table-borderless">
                        <tbody>
                            <tr>
                                <td>Pharmacy Information :</td>
                            </tr>
                            <tr>
                                <th>Pharmacy Date :</th>
                                <td>{{ date('d-m-Y', strtotime($sales_details->created_at)) }}</td>
                            </tr>
                            <tr>
                                <th>Pharmacy Id :</th>
                                <td>{{ $sales_details->code }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="col-2 col-sm-2 col-md-2 col-lg-2">
            </div>--}}
        </div>
        <div class="row invoive-info">
            <div class="col-6 col-sm-6 col-md-6 col-lg-6 invoice-client-info">
                <div style="padding: 6px;">
                    <h6>Customer Information :</h6>
                    <h6 class="m-0">Name: {{ $sales_details->customer_name }}</h6>
                    <h6 class="m-0">Code: {{ isset($sales_details->patient->code) ? $sales_details->patient->code : '' }}</h6>
                    <h6 class="m-0">Address: {{ $sales_details->customer_address }}</h6>
                </div>
            </div>
            <div class="col-6 col-sm-6 col-md-6 col-lg-6">
                <div class="row" style="margin-left: 4px;">
                    <h6>Payment Mode :{{ \FormHelper::getPaymentText($sales_details->mode) }} </h6>
                </div>
            </div>    
        </div>
        <div class="row">
            <div class="col-sm-12">
                <div class="table-responsive">
                    <table class="table  invoice-detail-table">
                        <thead>
                            <tr class="thead-default">
                                <th>Stock Catagory</th>
                                <th>Name</th>
                                <th>MRP</th>
                                <th>Unit Price</th>
                                <th>No.of.Units</th>
                                <th>GST</th>
                                <th>Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $tax_total = 0;
                                $sub_total = 0;
                                $taxable_amount = 0;
                            @endphp

                            @foreach($sales_list as $list)
                                <tr>
                                    <td>{{ $list->category_name }}</td>
                                    <td width="350px">{!! wordwrap($list->stock->stock_name,15,"<br>",true) !!}  </td>
                                    <td width="100px">{{ $list->selling_cost }}</td>
                                    <td width="100px">{{ $list->purchase_cost }}</td>
                                    <td width="100px">{{ $list->sales_quantity }}</td>
                                    <td width="100px">{{ $list->gst }}</td>
                                    <td width="100px">{{ $list->sub_total }}</td>                                    
                                </tr>
                            @endforeach

                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="row">

            <div class="col-6 col-sm-6 col-md-6 col-lg-6">
                <div class="table">
                    <table class="table">
                        <caption style="caption-side: top;">Tax Summary</caption>
                        <thead>
                            <tr class="">       
                                <th>Taxable Amount</th>                   
                                <th>IGST</th>
                                <th>CGST</th>
                                <th>SGST</th>
                                {{-- <th>Kerala Flood cess @1%</th> --}}
                            </tr>
                        </thead>
                        <tbody>
                                <tr>
                                    <td>{{ number_format(($sales_details->sales_total - $sales_details->tax_amount),2) }}</td>
                                    <td>0.0</td>
                                    <td>{{ number_format($sales_details->cgst,2) }}</td>
                                    <td>{{ number_format($sales_details->sgst,2) }}</td>
                                    {{-- <td>{{ $sales_details->cess }}</td> --}}
                                </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="col-6 col-sm-6 col-md-6 col-lg-6">
                <table class="table table-responsive invoice-table invoice-total">
                    <tbody>
                        {{-- <tr>
                            <th>Pharmacy total :</th>
                            <td>{{ $sales_details->sales_total }}</td>
                        </tr>
                        <tr>
                            <th>Discount ( {{ $sales_details->discount_percent }}% ) :</th>
                            <td>{{ $sales_details->discount_amount }}</td>
                        </tr> --}}
                        <tr>
                            <th>Taxable :</th>
                            <td>{{ number_format(($sales_details->sales_total - $sales_details->tax_amount),2) }}</td>
                        </tr>
                        <tr>
                            <th>Tax :</th>
                            <td>{{  $sales_details->tax_amount - $sales_details->cess }}</td>
                        </tr>
                        {{-- <tr>
                            <th>Kerala Flood cess @1%</th>
                            <td>{{ $sales_details->cess }}</td>
                        </tr> --}}
                        <tr>
                            <th>Rounded Off Amount :</th>
                            <td>{{ $sales_details->round_off_amount }}</td>
                        </tr>
                        <tr>
                            <td>
                                <hr/>
                                <h5>Grand Total :</h5>
                            </td>
                            <td>
                                <hr/>
                                <h5>{{ $sales_details->sales_total }}</h5>
                                {{-- <h5 class="text-primary">{{ $sales_details->grand_total }}</h5> --}}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>  
        <div class="row">
            <div class="col-sm-12">
                <h6>Terms And Condition :</h6>
                <p>{{ \Config::get('formdata.phymacy_tc') }} </p>
            </div>
        </div>
    </div>
</div>
<!-- Invoice card end -->
<div class="row text-center">
    <div class="col-sm-12 invoice-btn-group text-center">
        <button type="button" class="btn btn-primary btn-print-invoice m-b-10 btn-sm waves-effect waves-light m-r-20" onclick='printDiv();'>Print</button>
    </div>
</div>
</div>
</div>
<!-- Container ends -->


@endsection

@section('scripts')
<script type="text/javascript">
    function printDiv() 
    {
        var divToPrint=document.getElementById('DivIdToPrint');
        var newWin=window.open('','Print-Window');
        newWin.document.open();
        newWin.document.write('<html><head><link rel="stylesheet" type="text/css" href="{{ \URL::asset('css/bootstrap.min.css') }}"><link rel="stylesheet" type="text/css" href="{{ \URL::asset('css/style.css') }}"></head><body onload="window.print()"><div style="overflow:auto;">'+divToPrint.innerHTML+'</div></body></html>');
        newWin.document.close();
        setTimeout(function(){newWin.close();},10);
    }
</script>
@endsection


