@extends('layouts.app')


@section('header')

<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Edit Purchase</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="{{ \URL::to('/')}}">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="{{ \URL::to('stockPurchase/view') }}">List Purchase</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Edit Purchase</a>
                </li>
            </ul>
        </div>
    </div>
</div>

@endsection

@section('content')

<div class="card">
    <div class="card-block">

      <form class="form-horizontal create_purchase" role="form" 
      method="POST" action="{{ url('/stockPurchase/update/'.$purchase_details->purchase_id) }}">

        {{ csrf_field() }}

        <div class="box-body">


          <div class="box box-default">
            <div class="box-body">
              <div class="row">
                <div class="col-sm-3">
                  <div class="form-group">
                    <label>Supplier Name</label>
                    <input type="text" class="form-control search_supplier_name" placeholder="Type here ..." name="supplier_name" autocomplete="off" value="{{ $purchase_details->supplier_name }}">
                    <span class="help-block search_supplier_name_empty" style="display: none;">No Results Found ...</span>
                    <input type="hidden" class="search_supplier_id" name="supplier_id" value="{{ $purchase_details->supplier_id }}">
                  </div>
                </div>

                <div class="col-sm-3">
                  <div class="form-group">
                    <label>Address</label><br>
                    <input type="text" class="form-control search_supplier_address" name="supplier_address" autocomplete="off" value="{{ $purchase_details->supplier_address }}">
                  </div>
                </div>

                <div class="col-sm-2">
                  <div class="form-group">
                    <label>Contact</label><br>
                    <input type="text" class="form-control search_supplier_contact1" name="supplier_contact1" autocomplete="off" value="{{ $purchase_details->supplier_contact1 }}">
                  </div>
                </div>

                <div class="col-sm-2">
                  <div class="form-group">
                    <label>Opening Balance</label><br>
                    <input type="text" name="opening_balance" class="form-control opening_balance" readonly="" value="{{ $purchase_details->opening_balance }}">
                  </div>
                </div>

                <div class="col-sm-2">
                  <div class="form-group">
                    <label>Opening Due</label><br>
                    <input type="text" name="opening_due" class="form-control opening_due" readonly="" value="{{ $purchase_details->opening_due }}"> 
                  </div>
                </div>

              </div>
            </div>
          </div>

          <div class="box box-default">

              <div class="box-body">

                <table class="table table-striped">
                  <thead>
                    <tr>
                      <th>Stock Catagory</th>
                      <th>Physical Quantity</th>
                      <th>No.of.Units</th>
                      <th>Cost/Unit</th>
                      <th>GST</th>
                      <th>Total</th>
                      <th></th>
                    </tr>
                  </thead>
                  <tbody class="purchase_container">
                    @foreach($purchase_list as $list)
                    <input type="hidden" name="old_stock_details[]" value="{{ $list->stock->stock_id.'_'. $list->purchase_quantity }}">
                    <tr>
                      <td width="100px">
                        <input type="text" class="form-control search_purchase_category_name" placeholder="Type here ..." name="category_name[]" autocomplete="off" value="{{ $list->category_name }}">
                      <span class="help-block search_purchase_category_name_empty" style="display: none;">No Results Found ...</span>
                      <input type="hidden" class="search_category_id" name="category_id[]" value="{{ $list->category_id }}">
                      </td>
                      <td width="350px">
                        <select class="form-control purchase_stock_id" name="stock_id[]">
                          <option selected="" value="{{ $list->stock->stock_id }}">{{ $list->stock->stock_name }}</option>
                        </select>
                        <span></span>
                      </td>
                      
                      <td width="150px">

                        <input type="hidden" class="search_stock_quantity" name="opening_stock[]" value="{{ $list->opening_stock }}">
                        <input type="hidden" class="closing_stock" name="closing_stock[]" value="{{ $list->closing_stock }}">

                        <input type="text" class="form-control change_purchase_quantity" name="purchase_quantity[]" min="0" autocomplete="off" value="{{ $list->purchase_quantity }}">
                      </td>
                      
                      <td width="150px">
                        <input type="text" class="form-control search_purchase_cost" name="purchase_cost[]" value="{{ $list->purchase_cost }}">
                      </td>

                      <td width="100px">
                        <select class="form-control gst" name="gst[]">
                          @foreach($gst as $g)
                            @if($list->gst == $g)
                              <option value="{{ $g }}" selected>{{ $g.' %' }}</option>
                            @else
                              <option value="{{ $g }}" >{{ $g.' %' }}</option>
                            @endif
                          @endforeach
                        </select>
                      </td>

                      <td width="150px">
                        <input type="text" class="form-control stock_total" name="sub_total[]"  readonly="" value="{{ $list->sub_total }}">
                      </td>

                      <td><button type="button" class="btn btn-danger purchase_remove_tr">&times;</button></td>
                    </tr>
                    @endforeach
                  </tbody>
                  <tfoot>
                    <tr>
                      <td colspan="3">
                        <button type="button" class="btn btn-primary add_purchase_product"><i class="fa fa-plus"></i> Add More</button>
                      </td>
                      <td></td>
                    </tr>
                  </tfoot>
                </table>
                {{-- <div class="row">
                  <div class="col-md-3">
                    <div class="form-group">
                      <label>Stock Category</label><br>

                      <input type="text" class="form-control search_purchase_category_name" placeholder="Type here ..." name="category_name" autocomplete="off">
                      <span class="help-block search_purchase_category_name_empty" style="display: none;">No Results Found ...</span>
                      <input type="hidden" class="search_category_id" name="category_id">
                      
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      
                      <label>Physical Quantity </label><br>
                      <select class="form-control stock_id" name="stock_id">
                        <option selected="" disabled="" value="">select</option>
                      </select>
                    </div>
                  </div>
                  <div class="col-md-2">
                    <div class="form-group">
                      
                      <label>Opening Stock </label><br>
                      <input type="text" class="form-control search_stock_quantity" name="opening_stock" readonly="">
                      <input type="hidden" name="closing_stock" class="closing_stock">

                    </div>
                  </div>
                  <div class="col-md-2">
                    <div class="form-group">
                      <label>No.of.Units</label><br>
                      <input type="text" class="form-control change_purchase_quantity" name="purchase_quantity" min="0" autocomplete="off">
                    </div>  
                  </div>

                  <div class="col-md-2">
                    <div class="form-group">
                      <label>Purchase Cost</label><br>
                      <input type="text" class="form-control search_purchase_cost" name="purchase_cost">
                    </div>
                  </div>
                </div> --}}

                <div class="row">
                  
                  <div class="col-md-offset-8 col-md-4">
                    <div class="form-group">
                      <label>Purchase Total</label><br>
                      <input type="text" class="form-control purchase_total" readonly="" name="purchase_total" value="{{ $purchase_details->purchase_total }}">
                    </div>
                  </div>

                </div>

                <div class="row">
                  <div class="col-md-offset-4 col-md-4">
                    <div class="form-group">
                      <label>Discount ( % )</label><br>
                      <input type="number" class="form-control purchase_discount_percent" name="discount_percent" step="0.01" min="0" max="100" value="{{ $purchase_details->discount_percent }}">
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Discount ( Amount )</label><br>
                      <input type="text" class="form-control purchase_discount_amount" name="discount_amount" step="0.01" min="0" value="{{ $purchase_details->discount_amount }}"  readonly="">
                    </div>
                  </div>
                </div>

                <!-- <div class="row">

                  <div class="col-md-4">
                    <div class="form-group">
                      <label>GST Description</label><br>
                      <input type="text" class="form-control" name="tax_description" value="{{ $purchase_details->tax_description }}">
                    </div>
                  </div>

                  <div class="col-md-4">
                    <div class="form-group">
                      <label>GST ( % )</label><br>
                      <input type="number" class="form-control purchase_tax_percent" name="tax_percent"  step="0.01" min="0" max="100" value="0" value="{{ $purchase_details->tax_percent }}">
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>GST ( Amount )</label><br>
                      <input type="text" class="form-control purchase_tax_amount" name="tax_amount"   step="0.01" min="0" value="0" value="{{ $purchase_details->tax_amount }}">
                    </div>
                  </div>
                </div> -->

              </div>
          </div>

          <div class="box box-default">
            <div class="box-body">
              <div class="row">

                <!-- <div class="col-sm-2">
                  <div class="form-group">
                    <label>Description</label><br>
                    <textarea class="form-control" style="height: 35px;" name="description" autocomplete="off">{{ $purchase_details->description }}</textarea>
                  </div>
                </div> -->
                
                <div class="col-sm-2">
                  <div class="form-group">
                    <label>Grand Total</label><br>
                    <input type="text" class="form-control grand_total" name="grand_total" readonly="" value="{{ $purchase_details->grand_total }}">
                  </div>
                </div>

                <div class="col-sm-2">
                  <div class="form-group">
                    <label>Payment</label><br>
                    <input type="text" class="form-control purchase_payment" name="payment" autocomplete="off" value="{{ $purchase_details->payment }}">
                  </div>
                </div>

                <div class="col-sm-2">
                  <div class="form-group">
                    <label>Closing Balance</label><br>
                    <input type="text" class="form-control closing_balance" name="closing_balance" readonly="" value="{{ $purchase_details->closing_balance }}">
                  </div>
                </div>

                <div class="col-sm-2">
                  <div class="form-group">
                    <label>Closing Due</label><br>
                    <input type="text" class="form-control closing_due" name="closing_due" readonly="" value="{{ $purchase_details->closing_due }}">
                  </div>
                </div>

                <div class="col-sm-2">
                  <div class="form-group">
                    <label>Mode</label>
                    <select class="form-control" name="mode">                      
                      @foreach($payment as $pay)
                        <option value="{{ $pay['id'] }}" {{ ($purchase_details->mode == $pay['id']) ? 'selected' : ''  }}>{{ $pay['text'] }}</option>
                      @endforeach
                    </select>
                  </div>
                </div>

              </div>
            </div>
          </div>

        </div>
        <!-- /.box-body -->

        <div class="box-footer">
          <button type="reset" class="btn btn-danger pull-left">Reset</button>
          <button type="submit" class="btn btn-primary pull-right"><i class="fa fa-edit"></i> Update</button>
        </div>
</form>
  </div>
</div>
@endsection

@section('scripts')
  @include('inventory.purchase.inc.script')
@endsection
