@extends('layouts.app')

@section('header')
<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Purchase</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="{{ \URL::to('/')}}">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="{{ \URL::to('purchase/view') }}">List Purchase</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Show Purchase</a>
                </li>
            </ul>
        </div>
    </div>
</div>

@endsection

@section('content')

@php

$address = \Config::get('formdata.address');

@endphp

<!-- Basic Form Inputs card start -->
<!-- Invoice card start -->
<div class="card" id="DivIdToPrint">    
    <div class="card-block">
        <div class="row invoice-contact">
            <div class="col-12 col-sm-12 col-md-12 col-lg-12">
                <img src="{{ \URL::asset('images/main_logo.png') }}" width="100" height="100" class="m-b-10" alt="">
            </div>
            <div class="col-6 col-sm-6 col-md-6 col-lg-6">
                <div class="invoice-box row">
                    <table class="table table-responsive invoice-table table-borderless">
                        <tbody>
                            <tr>
                                <td>{{ $address['name'] }}</td>
                            </tr>
                            <tr>
                                <td>{{ $address['add1']  }}</td>
                            </tr>
                            <tr>
                                <td>{{ $address['add2']  }}</td>
                            </tr>
                            <tr>
                                <td>{{ $address['phone'] }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="col-6 col-sm-6 col-md-6 col-lg-6">
                <div class="invoice-box row">
                    <table class="table table-responsive invoice-table table-borderless">
                        <tbody>
                            <tr>
                                <td><b>Purchase Information</b></td>
                            </tr>
                            <tr>
                                <td><b>Purchase Date:</b>  {{ date('d-m-Y', strtotime($purchase_details->created_at)) }}</td>
                            </tr>
                            <tr>
                                <td><b>Purchase Id:</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{ $purchase_details->code }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="row invoive-info">
            <div class="col-6 col-sm-6 col-md-6 col-lg-6 invoice-client-info">
                <div style="padding: 6px;">
                    <h6>Supplier Information :</h6>
                    <h6 class="m-0">Name: {{ $purchase_details->supplier_name }}</h6>
                    <p class="m-0 m-t-10">Address: {{ $purchase_details->supplier_address }}</p>
                </div>
            </div>
            <div class="col-6 col-sm-6 col-md-6 col-lg-6">
                <div class="row" style="margin-left: 4px;">
                    <h6>Payment Mode :{{ \FormHelper::getPaymentText($purchase_details->mode) }} </h6>
                </div>
            </div> 
        </div>
        <div class="row">
            <div class="col-sm-12">
                <div class="table-responsive">
                    <table class="table  invoice-detail-table">
                        <thead>
                            <tr class="thead-default">
                                <th>Stock Catagory</th>
                                <th>Name</th>
                                <th>No.of.Units</th>
                                <th>Cost/Unit</th>
                                <th>GST</th>
                                <th>Total</th>
                            </tr>
                        </thead>
                        <tbody>
                             @foreach($purchase_list as $list)
                            <?php //dd($list['service_name']); ?>
                            <tr>
                                <td>{{ $list->category_name }}</td>
                                <td width="350px">{!! wordwrap($list->stock->stock_name,15,"<br>",true) !!}  </td>
                                <td width="100px">{{ $list->purchase_quantity }}</td>
                                <td width="100px">{{ $list->purchase_cost }}</td>
                                <td width="100px">{{ $list->gst }}</td>
                                <td width="100px">{{ $list->sub_total }}</td>
                            </tr>
                            @endforeach

                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="row">

            <div class="col-6 col-sm-6 col-md-6 col-lg-6">
                <div class="table">
                    <table class="table">
                        <caption style="caption-side: top;">Tax Summary</caption>
                        <thead>
                            <tr class="">       
                                <th>Taxable Amount</th>                   
                                <th>IGST</th>
                                <th>CGST</th>
                                <th>SGST</th>
                                {{-- <th>Kerala Flood cess @1%</th> --}}
                            </tr>
                        </thead>
                        <tbody>
                                <tr>
                                    <td>{{ number_format($purchase_details->grand_total - $purchase_details->tax_amount,2) }}</td>
                                    <td>0.0</td>
                                    <td>{{ number_format($purchase_details->tax_amount/2,2) }}</td>
                                    <td>{{ number_format($purchase_details->tax_amount/2,2) }}</td>
                                    {{-- <td>0.0</td> --}}
                                </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="col-6 col-sm-6 col-md-6 col-lg-6">
                <table class="table table-responsive invoice-table invoice-total">
                    <tbody>
                        <tr>
                            <th>Purchase total :</th>
                            <td>{{ ($purchase_details->purchase_total - $purchase_details->tax_amount) }}</td>
                        </tr>
                        <tr>
                            <th>Discount ( {{ $purchase_details->discount_percent }}% ) :</th>
                            <td>{{ $purchase_details->discount_amount }}</td>
                        </tr>
                        <tr>
                            <th>Tax :</th>
                            <td>{{ $purchase_details->tax_amount }}</td>
                        </tr>
                        {{-- <tr>
                            <th>Kerala Flood cess @1%</th>
                            <td>0.0</td>
                        </tr> --}}
                        <tr>
                            <th>Total :</th>
                            <td>{{ $purchase_details->grand_total - $purchase_details->round_off_amount }}</td>
                        </tr>
                        <tr>
                            <th>Rounded Off Amount :</th>
                            <td>{{ $purchase_details->round_off_amount }}</td>
                        </tr>
                        <tr>
                            <td>
                                <hr/>
                                <h5>Grand Total :</h5>
                            </td>
                            <td>
                                <hr/>
                                <h5>{{ $purchase_details->grand_total }}</h5>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>  
        <div class="row">
            <div class="col-sm-12">
                <h6>Terms And Condition :</h6>
                <p>{{ \Config::get('formdata.billing_tc') }} </p>
            </div>
        </div>
    </div>
</div>
<!-- Invoice card end -->
<div class="row text-center">
    <div class="col-sm-12 invoice-btn-group text-center">
        <button type="button" class="btn btn-primary btn-print-invoice m-b-10 btn-sm waves-effect waves-light m-r-20" onclick='printDiv();'>Print</button>
    </div>
</div>
</div>
</div>
<!-- Container ends -->


@endsection

@section('scripts')
<script type="text/javascript">
    function printDiv() 
    {
        var divToPrint=document.getElementById('DivIdToPrint');
        var newWin=window.open('','Print-Window');
        newWin.document.open();
        newWin.document.write('<html><head><link rel="stylesheet" type="text/css" href="{{ \URL::asset('css/bootstrap.min.css') }}"><link rel="stylesheet" type="text/css" href="{{ \URL::asset('css/style.css') }}"></head><body onload="window.print()"><div style="overflow:auto;">'+divToPrint.innerHTML+'</div></body></html>');
        newWin.document.close();
        setTimeout(function(){newWin.close();},10);
    }
</script>
@endsection


